          LIST P=16F628
	include <p16F628a.inc>
; File: 628dcc11.asm
; This version incorporates a speedkey feature developed by David P. Harris
; Introducing 128 speed steps
; 
;
; 010120 Added autorepeat, and inverted keyboard			DPH
;		Autorepeat starts after a delay of RptDly and an 	DPH
;		initial rate of RptSpdi.  RptSpdi is decremented	DPH
;		everytime through the loop until it reaches RptMax	DPH
;		NB: conditional assembly used
FLIPKEYBD = 0	; 0 = Robert's KB, 1 = David's KB			DPH
AUTOREPEAT = 1	; 0 = no autorepeat, 1 = autorepeat			DPH
TEST = 0       ; 0 = no test, 1 = issues sync pulse on pin Ra4 (Pullup)
DISPLAY = 162  ;Display 162 = 16X2 character, 204 = 20x4

;This version includes service mode - 4 types
; 2 Standard speed steps - 14 and 28 (Selectable)
;
;This is the first version to use the new 16f628 2K device
; This new version incorporates turnout control (accessories decoder control)       
;DCC Controller - Using Multiplex Keyboard 4x4 and LCD Readout
; Uses RA5 to access turnout decoder menu - Loco packets remain
; active during turnout menu.
;Drives four locomotives at any selectable address (3, 4, 5 and 6 default on initial startup)
;
;Function Fl supported - Headlights ON and OFF
;Output to Booster on Porta,0 RA0 (pin 2)
;Pin 3 is the menu select for turnout control - functions partly implemented
; Using internal 4Mhz oscillator - all unit tested to date are within tolerance
; this version works only with 4X20 display
; Information below not updated - left there for reference - check code
;  
; Note: in this version, 
;Clock is 4mHz ceramic resonator (or Crystal)  - Timing based on this clock
;Configuration: XS - WatchDog (WDT):OFF - Power On Timer (PWT):ON
;
;The following are the connections from the PIC to the LCD module (pin 1-14) Standard 16x2 char.
;
;Enable for LCD on Porta,1 RA1 (pin 18) to LCD pin 6 - LCD Pin 5 R/W to Ground
;RS on Portb,4 RB4 (pin 10) to LCD pin 5 (this is the read select - data or instruction
;I/O 1 to 4 is on PortB 0 to 3 RB0-RB3 (pin 6,7,8 and 9) to LCD pin 11,12,13,14
; On the LCD, Pin 1 is ground and pin 2 is +5v - pin 3 is a voltage between 0-5v for contrast.
; Other pins are not used. This is using the 4 bit protocole for the LCD
;
; uses 4*4 matrix keybord with 2.2k between RB4-7 and keyboard and RB0-3
; Preset address 3-4-5 et 6 (Can be changed from 0 to 127 (display
;   will show only two last digits - 00 to 99 and 00 to 27)
;
;
; LDC Style:         |====================|
; (20 char x4 lines) |MiniDCC Station v1.5|
;                    |Loc:003*004*005-006*|
;		     |	  >000>000>022>002|
;                    |                    | 
;                    |====================| 
;
; First line indicates loco address with Star indicating Light ON
;   and "-" indicating lights off - Function Group 1 (FL)
; Direction "->" before speed indicates Forward or Reverse "<-" 
;
; Matrix keyboard 16 switches to control 4 locos
;
;
;      C1 C2 C3 C4
;     ===============
; R1  = 13 14 15 16 =
; R2  =  9 10 11 12 =
; R3  =  5  6  7  8 = 
; R4  =  1  2  3  4 =
;     ===============
; Note 1 : On my setup, I use the following buttons for various functions:
;       Button 1 = Speed Increase (step 0-31) - Loco 1 - address 03
;       button 2 = Speed Decrease 
;       Button 3 = Direction Change
;       Button 4 = Headlights On or OFF
;       Button 5 = Speed Increase (Loco2) etc...   address 04 ...
; I have a version with 128 speed steps - but it becomes tedious to 
; push the buttons to increase and decrease speed
; I am developing another version using a 16c71 (and) a 16c73 that uses
; four Potentiometers for speed control 
;
; Additional Switches on PortA,2 RA2 (Pin 1) and PortA,3 RA3 (Pin2)
;  for Emergency Stop Toggle (all locos) and Service Operations Mode toggle
;  Connect with Pull-up (appx 2.2k) to V+ and short to ground with switch
;
; LDC Style:         |==================|
; (16 char x2 lines) | Statn#1 #2 #3 #4 |
;                    | Addr 03`04 05 06 |
;                    |==================|
; 
;  Pressing Service mode switch brings up 2 programming functions:
;      1 - Station address programming
;               Press button 1 and 2 to change loco 1 Station address
;               Press button 5 and 6 to change loco 2 Station address
;               Press...
;      2 - To change from 28 to 14 step, press button - press button 4, 8,
;           12 and 16 respectively - a small ` will appear near the address
;           to indicate 14 speed mode.    
;      3 - Values in 1 and 2 above will remain in memory even with power off
;

; LDC Style:         |==================|
; (16 char x2 lines) | Serv Mode Pag/Rg |
;                    | CV:001-000 01-00 |
;                    |==================| 
;
;  Pressing Service mode once more will move to CV Programming mode
;       1 - In this mode, CV# are changed with button 1 and 2
;       2 - CV Values are changed with button 5 and 6
;       3 - Press button 3,7,11 or 15 to send signal to decoder
;          (Ensure only one decoder at a time on programming track)
;       4 - Four (4) modes of programming are supported:
;              Button 3 sends Page programming 
;                   (see right of display for Page/Reg information)
;              Button 7 sends Physical register code (1 to 8)
;              Button 11 sends Direct Programming code (1 to 256)
;              Button 15 sends Advanced Direct Programming (1 to 256)  
;
; Note 2 : It is possible to operate without the LCD readout (for a very
;          inexpensive DCC control) using LEDs on portb to show speed step.
; 	 : in this case just ignore the connection to the LCD module
;	 : on power-up, the default is a reset then forward all loco speed 0
;	 : by repeatedly pushing button 1, speed will increase from 0 to 31
;	 : going from Stop, EStop, 1,2,3,... to 28	           
; 
; Note 3 : A booster must be connected between the output of the 16c84 and the track
;	 :  many schematic exist on the internet - this is simple to build.
;
; Note 4 : This version was tested with Digitrax FX decoders (N and H)
;           programming mode works with all of them
;        ; Use Register and Page for MRC decoder
;        ; Advanced and Direct decoding does not work with MRC - TCR414W1-97
;          but works ok with page and direct register programming
;        ; Not tried with Lenz or other make (I don't have any!)
;               
;
; Note 5 : Code was optimised with numerous GOTOs instead of CAlls and 
;               RETURNn to save code space
;
;
;             18 17 16 15 14 13 12 11 10  
;            |---------------------------|
;            |                           | 
;            |    16c84  or 16f84        |
;            |---------------------------|
;              1  2  3  4  5  6  7  8  9
;
;
;---------------------------------------------------------------------------
;       Revision Date:   June 1998/January 2001
;       Copyright(c) DbRc 1998 - Robert Cote - Denise Baribeau
;                                 Ottawa - Canada
;
;             NOTE: This code is not in the public domain - It cannot
;                   be used commercially without the written permission
;                   of the author.
;---------------------------------------------------------------------------                                                        
;
; Output TTL compatible - uses L298 booster - Should work with any
;                                       standard booster
; Credits : Microchip (for matrix key board routine)
;           Mike Brandt for the ideas on the PC assembler Driver
;           John Becker for LCD/BCD Routines and his excellent turorial
;               published in Everyday Practical Electronics (March/April
;               and May 1998)
;            DCC pulse generation - NMRA Sarps and my own translation
;                into assembler code               
;               
;         
;******************************************************************************
;
; Brown Out feature disabled to prevent early reset of chip on spikes

      __config _WDT_OFF&_LVP_OFF&_INTRC_OSC_NOCLKOUT&_PWRTE_ON&_BODEN_OFF;&_MCLRE_OFF
;       __config _WDT_OFF&_LVP_OFF&_XT_OSC&_PWRTE_ON&_BODEN_ON;&_MCLRE_OFF
;      __config _WDT_OFF&_LVP_OFF&_INTRC_OSC_NOCLKOUT&_PWRTE_ON&_BODEN_ON;&_MCLRE_OFF
        ERRORLEVEL  -302

; Defines ------------------------------------------------



; Macros

Bank0           macro
		bcf Status,RP0
;		bcf Status,RP1       ;not required if bank2 and 3 are not used!
		endm
Bank1           macro
		bsf Status,RP0
;		bcf Status,RP1
		endm
Bank2           macro
		bcf Status,RP0
		bsf Status,RP1
		endm
Bank3           macro
		bsf Status,RP0
		bsf Status,RP1
		endm

; Equates ------------------------------------------------

Version1              equ     '5'   ;Translates to Version x.x in MiniDcc Heading
version2              equ     '4'


Loco1Add        equ     .3      ;preset loco#1 to 4 address (3,4,5 and6)
Loco2Add        equ     .4
Loco3Add        equ     .5
Loco4Add        equ     .6

keyhit          equ     .0              ;bit 0 --> key-press on
DebnceOn        equ     .1              ;bit 1 --> debounce on
noentry         equ     .2              ;no key entry = 0
ServKey         equ     .3              ;bit 3 --> service key
ServMod         equ     .4 
ServBusy        equ     .5
EstopOn         equ     .6
EstopBusy       equ     .7     
DirFlag         equ     .5              ;for 14 and 28 speed steps
DirFlag128      equ     .7              ;bit 7 for 128 step in advanced mode
FlFlag          equ     .4              ;used with function group 1
ServRept        equ     .6              ;# of repeats for Service Commands
ResetRept       equ     .20             ;Reset repeat
CTDIV           equ     .99             ;Used to preset timer0
MaxSpeed28      equ     .31             ;now in binary format
MaxSpeed14      equ     .15
MaxSpeed128     equ     .127
LPreamb         equ     .25           ;Long Preamble (20) SRP 9...
SPreamb         equ     .15            ;Short Preamble (10) SRP 9... using 15 for MRC decoder
StepFlag1       equ     .0
StepFlag2       equ     .1
StepFlag3       equ     .2        
StepFlag4       equ     .3
StepFlag5       equ     .4
StepFlag6       equ     .5
StepFlag7       equ     .6        
StepFlag8       equ     .7
RegBase         equ     20h            ;Register starting address
EEROMBase       equ   2100h
LcdLine1        equ   b'10000000'
LcdLine2        equ   b'11000000'
LcdLine3        equ   b'10010100'
LcdLine4        equ   b'11010100'  
TurnDelay       equ   .50        ;maximum delay  0 to 126 - x .1second
AccMemory       equ   .123         ;First 5 used by Loco Address and 14/28 speed flag                                 

; Registers ----------------------------------------------

; Counter and Temporary Storage Registers

TempC   equ     RegBase+.00        ;temp general purpose RegBase
temp    equ     RegBase+.01
SavTmp1 equ     RegBase+.02
LOOPA   EQU     RegBase+.03        ;loop counter 2 - LCD use only

TempD   equ     RegBase+.04
R0      equ     RegBase+.05
SavTmp2 equ     RegBase+.06
        
TempE   equ     RegBase+.07
R1      equ     RegBase+.08
GetTmp  equ     RegBase+.09
R2      equ     RegBase+.10        ;added for BCD to 5 digit conversion
Temp2   equ     RegBase+.11        ;10 to 13 must remain contiguous in memory
MSB     equ     RegBase+.12
BCDmsb  equ     RegBase+.13


Debnce  equ     RegBase+.14        ;debounce counter


NewKey  equ     RegBase+.15
TCount  equ     RegBase+.16
PageNo  equ     RegBase+.17

STORE1  EQU     RegBase+.18        ;general store 1
ServCnt equ     RegBase+.19

STORE2  EQU     RegBase+.20        ;general store 2



RSLINE  EQU     RegBase+.21        ;RS line flag for LCD

PBBuf   equ     RegBase+.22

loops   equ     RegBase+.23

loops2  equ     RegBase+.24

txByte	equ	RegBase+.25     ; Transmitted byte (address, instructions,etc.)
count   equ     RegBase+.26

txCount	equ	RegBase+.27     ; Counter for transmit routine
LSB     equ     RegBase+.28

byte1bf	equ	RegBase+.29	; byte memory for dcc signal XOR - Error mode

byte2bf	equ	RegBase+.30

byte3bf	equ	RegBase+.31    

byte4bf	equ	RegBase+.32

; Flags and Important static storage registers


KeyFlag equ     RegBase+.33        ;flags related to key pad

spdir1	equ	RegBase+.34	; Speed and direction register
spdir2	equ	RegBase+.35	; Speed and direction register 2 ...
spdir3	equ	RegBase+.36	; 
spdir4	equ	RegBase+.37	; 
;-------------
;---- Do not change sequence from loco1ad to ACCTNum - Info from EEROM inserted here
;      on initialisation
;-----------------------------
loco1ad  equ	RegBase+.38	; save address of 1st loco here
loco2ad	 equ	RegBase+.39	;  etc...
loco3ad	 equ	RegBase+.40
loco4ad	 equ	RegBase+.41

SpdFlag  equ     RegBase+.42     ;14/28 speedstep flag - must follow above
AccAbcd1 equ     RegBase+.43
;-----------------------------------
fung1_1	equ	RegBase+.44	;function Group 1 (1 to 5) FL f1 f2 f3 f4 
fung1_2	equ	RegBase+.45
fung1_3	equ	RegBase+.46
fung1_4	equ	RegBase+.47	


bcdspd1 equ     RegBase+.48
bcdspd2 equ     RegBase+.49
bcdspd3 equ     RegBase+.50
bcdspd4 equ     RegBase+.51

ModeFl    equ   RegBase+.52     ;Mode 1-2-4-8 Normal /Programme1 ...
NewLoops  equ   RegBase+.53
TnOutFlag equ   RegBase+.54     ;Zero - Turnout/1 - Normal Mode bit 1 for recording bit 2 (max Seq)
                                ;Bit 3 for function mode (as part of turnout menu sequence)
AccPack1  equ   RegBase+.55
AccPack2  equ   RegBase+.56
ACCTemp1  equ   RegBase+.57
AccTemp2  equ   RegBase+.58
AccHold1  equ   RegBase+.59
ACCHold2  equ   RegBase+.60

AccTNum   equ   RegBase+.61
AccAbcd2  equ   RegBase+.62
AccATemp  equ   RegBase+.63
AccATemp2 equ   RegBase+.64

AccRoute  equ   RegBase+.65

	IF FLIPKEYBD == 1	;					DPH
TOPROW	equ	.3		;					DPH
SECROW	equ	.2		;					DPH
THIROW	equ	.1		;					DPH
	ENDIF			;					DPH
	IF FLIPKEYBD == 0	;					DPH
TOPROW	equ	.0		;					DPH
SECROW	equ	.1		;					DPH
THIROW	equ	.2		;					DPH
	ENDIF			;					DPH

	IF AUTOREPEAT == 1 	;					DPH
RDly		equ	.50		; repeat delay ~~1 sec		DPH	
RptDly	equ	RegBase+.14	; == debnce				DPH
RSpd		equ	.12	; (was 12) repeat speed(x2) ~~ 0.3 sec	DPH
RptMax	        equ	.12	; (.06) max repeat speed(x2) ~~ 0.1	DPH
RptSpd	equ	RegBase+.14	; == debnce				DPH
RptSpdi	equ	RegBase+.66 ; Autorepeat rate			DPH
;RptCol	equ	RegBase+.67 ; Mask to select col to repeatDPH
RCol0   equ     b'00000000' ; Select no column
RCol2	equ	B'00000011'		; select first two cols		DPH
RCol3	equ	B'00000111'		; select first three cols	DPH
RCol4   equ     b'00001111'             ; select 4 columns
	ENDIF			;					DPH
DoSeqFlag equ   RegBase+.68 ; if bit 0 = 1 we have a sequence of turnout to issue                                
NewLoops2 equ   RegBase+.69                                 
TurnCount equ   RegBase+.70 ;Tunrnout sequence counter
AccTDelta equ   RegBase+.71 ;Index for sequence on route
ACCRCount equ   RegBase+.72 ;Route counter for Delta calculation
AccTMem   equ   RegBase+.73 ;Total memory available (currently 123 bytes)
AccT1     equ   Regbase+.74
AccT2     equ   RegBase+.75 ;temporary storage for testing purposes
AccT3     equ   RegBase+.76
AccT4     equ   Regbase+.77
RevFlag   equ   RegBase+.78 ; Reverse Flag xxxx0000 forward, xxxx1111 reverse 


; The following information is imbedded in the EEROM memory
; First - default address 03, 04, 05 and 06 with 28 speed mode preset
; Second - the LCD Service mode text is saved as ASCIIz to save code space
; 
        org     2100h           ;Preset Loco address in EEROM

PMBase  de      .03,.04,.05,.06,b'00001111'
SeqMem  de      0,0,0,0,0,0,0,0,0,0,0
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0   ;123 memory block for sequencing available     
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        de      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;---------------------------------------------------------------

        org     .0
Begin   goto    Start
        org     .4	;interrupt vector (not used)
	goto    begin

;---------------------Table for LCD Readout

TABLCD: addwf PCL,F             ;LCD initialisation table
        retlw b'00110011'       ;initialise lcd - first byte
        retlw b'00110011'       ;2nd byte (repeat of first)
        retlw b'00110010'       ;set for 4-bit operation
        retlw b'00101000'       ;set for 2 line
        retlw b'00000110'       ;set entry mode to increment each address
        retlw b'00001100'       ;set display on, cursor off, blink off
        retlw b'00000001'       ;clear display
        retlw b'00000010'       ;return home, cursor & RAM to zero
                                ;end initialisation table        
         
;---------------------------------------------------------------------
; Keyboard Look-up Table

GetValCom
        movf    TempC,w     
        addwf   PCL, F
        retlw   .0
        retlw   .1
        retlw   .2
        retlw   .3
        retlw   .4
        retlw   .5
        retlw   .6
        retlw   .7
        retlw   .8
        retlw   .9
        retlw   0ah
        retlw   0bh
        retlw   0ch
        retlw   0dh
        retlw   0eh
        retlw   0fh

;--------------------------------------------------------------

CommandTable:
        addwf   PCL,f  ;this is a jump table according to key press

                                        ;       C1 C2 C3 C4
                                        ;     ===============
                                        ; R1  = 13 14 15 16 =
                                        ; R2  =  9 10 11 12 =
                                        ; R3  =  5  6  7  8 = 
                                        ; R4  =  1  2  3  4 =
                                        ;     ===============
        goto    Fl1             ;button 4 
        goto    Dir1            ;button 3
        goto    SpdDn1          ;button 2
        goto    SpdUp1          ;button 1

        goto    FL2             ;button 8 
        goto    Dir2            ;button 7 ...
        goto    SpdDn2
        goto    SpdUp2

        goto    FL3             
        goto    Dir3           
        goto    SpdDn3
        goto    SpdUp3

        goto    FL4             
        goto    Dir4           
        goto    SpdDn4
        goto    SpdUp4

;---------------------------------------------------------
PgmTable        
        addwf   PCL,f          
        goto    Pgm1    ;Station Address
        goto    Pgm2    ;Service Mode Direct CV writing
        goto    Pgm4    ;turnout programming mode        
        goto    Pgm3    ;Operations mode (normal)
;----------------------------------------------------------
        IF DISPLAY == 204
PMMsg1  addwf  PCL,F

	retlw 'S'
        retlw 't'
        retlw 'a'
        retlw 't'
        retlw 'n'
        retlw ' '
        retlw '#'
        retlw '1'
        retlw ' '
        retlw ' '
        retlw '#'
        retlw '2'
        retlw ' '
        retlw ' '
        retlw '#'
        retlw '3'
        retlw ' '
        retlw ' '
        retlw '#'
        retlw '4'
        retlw .0
        ENDIF
        IF DISPLAY == 162
PMMsg1  addwf  PCL,F

	retlw 'S'
        retlw 't'
        retlw 'a'
        retlw 't'
        retlw 'n'        
        retlw '#'
        retlw '1'
        retlw ' '
        retlw '#'
        retlw '2'
        retlw ' '
        retlw '#'
        retlw '3'
        retlw ' ' 
        retlw '#'
        retlw '4'
        retlw .0
        ENDIF
;----------------------------
;        retlw '#'        "Statn #1  #2  #3  #4",0             
;----------------
        IF DISPLAY == 204
PMMsg2  addwf PCL,F
        retlw 'S'
        retlw 'e'
        retlw 'r'
        retlw 'v'
        retlw 'i'   ;de      "Service Mode Pag/Reg",0      ;
        retlw 'c'
        retlw 'e'
        retlw ' '
        retlw 'M'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw ' '
        retlw 'P'
        retlw 'a'
        retlw 'g'
        retlw '/'
        retlw 'R'
        retlw 'e'
        retlw 'g'
        retlw .0
        ENDIF
        IF DISPLAY == 162
PMMsg2  addwf PCL,F
        retlw 'S'
        retlw 'e'
        retlw 'r'
        retlw 'v'        
        retlw ' '
        retlw 'M'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw ' '
        retlw 'P'
        retlw 'a'
        retlw 'g'
        retlw '/'
        retlw 'R'        
        retlw 'g'
        retlw .0
        ENDIF

;--------------------------
        IF DISPLAY == 204
PMMsg3  addwf  PCL,F    ; de      "  Emergency Stop!   ",0      ;
        retlw ' '
        retlw ' '
        retlw 'E'
        retlw 'm'
        retlw 'e'   
        retlw 'r'
        retlw 'g'
        retlw 'e'
        retlw 'n'
        retlw 'c'
        retlw 'y'
        retlw ' '
        retlw 'S'
        retlw 't'
        retlw 'o'
        retlw 'p'
        retlw '!'
        retlw ' '
        retlw ' '
        retlw ' '
        retlw .0
        ENDIF
        IF DISPLAY == 162
PMMsg3  addwf  PCL,F    ; de      " Emergency Stop!",0      ;        
        retlw ' '
        retlw 'E'
        retlw 'm'
        retlw 'e'   
        retlw 'r'
        retlw 'g'
        retlw 'e'
        retlw 'n'
        retlw 'c'
        retlw 'y'
        retlw ' '
        retlw 'S'
        retlw 't'
        retlw 'o'
        retlw 'p'
        retlw '!'        
        retlw .0
        ENDIF
;-----------------------------------------------------------
        IF DISPLAY == 204
PMMsg4  addwf  PCL,F  ;     "MiniDCC Station v4.3",0      
        retlw 'M'
        retlw 'i'
        retlw 'n'
        retlw 'i'
        retlw 'D'   
        retlw 'C'
        retlw 'C'
        retlw ' '
        retlw 'S'
        retlw 't'
        retlw 'a'
        retlw 't'
        retlw 'i'
        retlw 'o'
        retlw 'n'
        retlw ' '
        retlw 'v'
        retlw Version1
        retlw '.'
        retlw version2
        retlw .0
        ENDIF
;---------------------------
        IF DISPLAY == 162        
PMMsg4  addwf  PCL,F  ;     "MiniDCC Station ",0      
        retlw 'M'
        retlw 'i'
        retlw 'n'
        retlw 'i'
        retlw 'D'   
        retlw 'C'
        retlw 'C'
        retlw ' '
        retlw 'S'
        retlw 't'
        retlw 'a'
        retlw 't'
        retlw 'i'
        retlw 'o'
        retlw 'n'
        retlw ' '
        retlw .0

PMMsg4b addwf PCL,f 
        retlw 'V'     ;'Version 5.x'
        retlw 'e'
        retlw 'r'
        retlw 's'
        retlw 'i'
        retlw 'o'
        retlw 'n'
        retlw ' '
        retlw Version1
        retlw '.'
        retlw version2
        retlw .0        
        ENDIF
;------------------------------------------------------------
   

        IF DISPLAY == 204
PMMsg6  addwf  PCL,F   ;de      "Turnout Control Mode",0
        retlw 'T'
        retlw 'u'
        retlw 'r'
        retlw 'n'
        retlw 'o'   
        retlw 'u'
        retlw 't'
        retlw ' '
        retlw 'C'
        retlw 'o'
        retlw 'n'
        retlw 't'
        retlw 'r'
        retlw 'o'
        retlw 'l'
        retlw ' '
        retlw 'M'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw .0
        ENDIF
        IF DISPLAY == 162
PMMsg6  addwf  PCL,F   ;de      "Turnout Control Mode",0
        retlw 'T'        
        retlw 'r'
        retlw 'n'
        retlw 'o'   
        retlw 'u'
        retlw 't'
        retlw ' '
        retlw 'C'      
        retlw 't'
        retlw 'r'        
        retlw 'l'
        retlw ' '
        retlw 'M'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw .0
        ENDIF
        IF DISPLAY == 204
PMMsg8  addwf  PCL,F   ;de      "Function Contrl Mode",0
        retlw 'F'
        retlw 'u'
        retlw 'n'
        retlw 'c'
        retlw 't'   
        retlw 'i'
        retlw 'o'
        retlw 'n'
        retlw ' '
        retlw 'C'
        retlw 'o'
        retlw 'n'
        retlw 't'
        retlw 'r'
        retlw 'l'
        retlw ' '
        retlw 'M'
        retlw 'o'
        retlw 'd'
        retlw 'e'
        retlw .0
        ENDIF
        IF DISPLAY == 162
;PMMsg8  addwf  PCL,F   ;de      "Function Contrl Mode",0
;        retlw 'F'
;        retlw 'u'
;        retlw 'n'
;        retlw 'c'
;        retlw 't'  
;        retlw 'n'
;        retlw ' '
;        retlw 'C'        
;        retlw 't'
;        retlw 'r'
;        retlw 'l'
;        retlw ' '
;        retlw 'M'
;        retlw 'o'
;        retlw 'd'
;        retlw 'e'
;        retlw .0
        ENDIF
;---------------------------------------------------------------
;   End of Tables (Ensure that this is within first 256 bytes) 00FFh
;---------------------------------------------------------------


Start
        call    InitPorts       ;Setup up all ports 
        call    InitLCD         ;Initialize LCD Display 
	IF AUTOREPEAT == 1	
;		movlw   RCol2	 ;Set Autorepeat to 2 columns		DPH
;		movwf   RptCol	 ;					DPH
	ENDIF							;	DPH       
	call	DCCReset	;send 20 reset pulses to initialize decoder                

MainLoop:
        movf    ModeFl,f
        btfss   Status,Z        ;if ModeF1=0 then operate
        goto    PgmMode         ;else programming mode               
Main1: 
        call    DCCIdle
        IF   TEST == 1          
          call    SyncPulse       ;Used for scope synchronization when testing
        ENDIF
        call    SendDCCPulse1   ;Send Loco#1 info (Preamble/Address/Speed)            
        call    SendDCCPulse2   ;send loco#2 info ...
        call    SendDCCPulse3
        call    SendDCCPulse4       
        call    DCCIdle
        call    FuncGroup1_1        
        call    FuncGroup1_2        
        call    FuncGroup1_3        
        call    FuncGroup1_4           
        btfsc   DoSeqFlag,0      ;If sequence flag On or still On go do sequence
        call    AccQuery
        btfsc   TnOutFlag,0      ;query turnout if in play mode for direct play                  
        call    AccQuery
        goto    MainLoop


PgmMode
        
        call    DCCReset
Pg1:    
        IF  TEST == 1      
         call    SyncPulse      ;only for testing purposes - not used in normal mode
        ENDIF
;        call    DCCIdle
        call    DCCIdle        
        call    KeyTest        
        movf    ModeFl,f
        btfsc   Status,Z        ;if ModeF1=0 then operate
        goto    Main1           ;else Service mode
        btfsc   TnOutFlag,1     ;only send turnout info if in turnout mode (Recording mode)
        call    AccQuery            
        goto    Pg1
        
KeyTest
        call    ScanKeys
        btfsc   KeyFlag,ServKey ;key service pending
        call    ServiceKey      ;yes then service 
       ; clrwdt                  ;reset the watchdog timer (must be done within 18ms)
        return


;---------------------------------------------------




InitPorts

        movlw   b'00000111' ; 0x07       ;comparator OFF
        movwf   CMCON      ;enable for i/o functions
        bank1             ;select pg 1
        movlw   b'00101100'     ;Make RA0/1/4 outputs RA2/3/5 as inputs 	
        movwf	TRISA		; 
        clrf    TRISB           ;make RB0-7 outputs
        bank0                   ;select page 0         
        clrf    PORTB           ;        
        movlw   RegBase + 1
        movwf   FSR
        movlw   .96 ;EndReg-StrReg   ;number of registers to clear
        movwf   TempC
Ini1:   clrf    INDF
        incf    FSR,f          ;clear all registers starting at 20h (RegBase)
        decfsz  TempC,f
        goto    Ini1        
        movlw   Loco1Ad         ;Get  Loco1 to 4 and SpeedFlag
        movwf   FSR
        clrf    loops           ;five values to retrieve 
Ini2:   movfw   loops
        call    GetPrm      
        movwf   INDF            ;fill registers from Loco1Ad to AccTNum with EEROM value    
        incf    FSR,f
        incf    loops,f
        movlw   b'00000110'     ;have we reached 6 yet
        xorwf   loops,w
        btfss   Status,Z
        goto    Ini2
        call    ClrBcd2          ;Go preset Speed and direction        
	movlw	b'10010000'	;default Headlight ON
	movwf	fung1_1	
	movwf	fung1_2
	movwf	fung1_3
	movwf	fung1_4 
        movlw   b'10000000'     ;default acc decoder to address 0 
        movwf   AccPack1
        movwf   ACCTemp1 
        movlw   b'11111000'     ;active - bank 0 acc decoder
        movwf   AccPack2
        movwf   ACCTemp2 
        incf    AccTNum,F         ;start at sequence 1 for turnout
        movlw   'A'
        movwf   AccRoute   
        return

;-----------------------------------------------------------------------------       
; Emergency Stop routine - all channels at once - Called from ScanKeys
;                                                       PortA
; show emergency stop on last line for 1 second then erase and
; return to operation       
;---------------------------------------------------------------
        	
Estop
        btfsc   KeyFlag,DebnceOn
        return
        movf    ModeFl,f
        btfss   Status,Z
        return                 
        bsf     KeyFlag,DebnceOn ;set flag
        movlw   .4
        movwf   Debnce          ;load debounce time
        btfsc   TnOutFlag,0
        return                  ;leave if not in ops mode
        incf    ModeFl,F        ;simulate out of ops mode temporarily
        IF DISPLAY == 204
        movlw   LcdLine4 ;Move cursor to fourth line
        ENDIF
        IF DISPLAY == 162
        movlw   LcdLine2 ;Move cursor to fourth line 
        ENDIF
        call    LcdLin
        clrf    loops       
Emer1:  movfw   loops      ;initiate W register for table lookup
	call    PMMsg3     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    Emer2
        call    LCDOut       
        goto    Emer1
Emer2:                      ;Stop but keep sending DCC info

        movfw   SpdFlag
        movwf   R1           ;save temporary copy of Speed flag -
        clrf    SpdFlag      ;force 14 speed protocol (lowest common denominator)   
        call    clrbcd       ;reduce speed to zero retain direction status
        movfw   spdir1       ;save real value for restoring later
        movwf   AccT1
        movfw   spdir2
        movwf   AccT2
        movfw   spdir3
        movwf   AccT3
        movfw   spdir4
        movwf   AccT4
        movlw   b'01000001'  ;Simulate emergency stop for 14 speed step (lowest denominator)
        movwf   Spdir1
        movwf   Spdir2
        movwf   Spdir3
        movwf   Spdir4
        btfss   RevFlag,0    ;restore direction to dummy emergency stop
        bsf     Spdir1,5     ;to maintain direction status on track
        btfss   RevFlag,1
        bsf     Spdir2,5
        btfss   RevFlag,2
        bsf     Spdir3,5
        btfss   RevFlag,3
        bsf     Spdir4,5         
        movlw   .10
        movwf   R0   ;use un-used register for now
Emer4:  
        movlw   .25
        movwf   loops        
        call    T2ms ;(Wait for 50ms) 
        btfss   PortA,3     ;do we want programming mode
        goto    Emer5       ;Jump to pgmMode1 but erase first!  
        call    dccIdle     ;ensure next pulse will get to loco 
                    
        call    SendDCCPulse1   ;Send Loco#1 info (Preamble/E-Stop/Speed00)
        call    SendDCCPulse2   
        call    SendDCCPulse3   
        call    SendDCCPulse4   
        call    DCCIdle                  
        decfsz  R0,F
        goto    Emer4               
        movfw   R1          ;restore speed flag parameters
        movwf   SpdFlag
        bcf     TnOutFlag,0  ;back to operating mode
        movfw   Acct1
        movwf   Spdir1
        movfw   Acct2
        movwf   Spdir2
        movfw   Acct3
        movwf   Spdir3
        movfw   Acct4
        movwf   Spdir4

        call    ClrBcd        
        call    ClkShw1
        call    ShowOps 
        clrf    ModeFl
        IF  DISPLAY == 204
        movlw   LCDLine4
        goto    EraseLine 
Emer5:  movlw   LCDLine4
        ENDIF
        IF DISPLAY == 162
        movlw   LCDLine2
        call    EraseLine 
        goto    ShowOps    ;show second line for 16*2 display
Emer5:  movlw   LCDLine2
        ENDIF
        call    EraseLine
        bcf     KeyFlag,DebnceOn ;key already debounced
        clrf    ModeFl
        movfw   R1          ;restore speed flag parameters
        movwf   SpdFlag
        goto    pgmMode1
        
;--------------------------------------------------------------

PgmMode1                        ;called from ScanKeys        
        btfsc   KeyFlag,DebnceOn
        return            
        bsf     KeyFlag,DebnceOn ;set flag
        movlw   .4
        movwf   Debnce
	IF AUTOREPEAT == 1  ;DPH
;	  movlw   RCol2	    ;Set Autorepeat to 2 columns			
;	  movwf   RptCol    ;
	ENDIF		    ;DPH

        call    ClrBcd2  
        movfw   ModeFl
        incf    ModeFl,f 
        ;bcf     KeyFlag,EStopON ;re-enable keyboard      
        goto    PgmTable
;------------------------------------------------
; Function Control routines - Added February 2001
;------------------------------------------------
FuncMode
        btfsc TnOutFlag,3   ;are we already in function mode, if so revet to ops
        goto  FuncQuit
        call  LCDClear     ;clear display
        
        bsf   TnOutFlag,3  ;flag Function mode for keyboard dispatch       
        ;call  ShowHead          
        IF DISPLAY == 204
        call    ShowHead
        movlw   LcdLine2   ;Move cursor to line 2
        call    LcdLin
        clrf    loops
        
Fun2:   movfw   loops      ;initiate W register for table lookup
	call    PMMsg8     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    FuncStatus
        call    LCDOut       
        goto    Fun2
        ENDIF

        
FuncStatus:
        IF DISPLAY == 204
        call    Clkshw3
FunUp:  movlw   LcdLine4    ;Move cursor to third line
        call    LCDLIN 
        call    LCDSpace
        call    LCDSpace
        call    LCDSpace
        call    LCDSpace
        ENDIF
        IF  DISPLAY == 162       
        call    Clkshw2
FunUp:  movlw   LcdLine2    ;Move cursor to second line
        call    LCDLIN 
        ENDIF
        movlw   Fung1_1
        movwf   FSR
        movlw   .4
        movwf   Count
Fun1:           
        movlw   '-'
        btfsc   indf,0
        movlw   '*'
        call    LcdOut
        movlw   '-'
        btfsc   indf,1
        movlw   '*'
        call    LcdOut
        movlw   '-'
        btfsc   indf,2
        movlw   '*'
        call    LcdOut
        movlw   '-'
        btfsc   indf,3
        movlw   '*'
        call    LcdOut
        incf    FSR,F
        decfsz  count,F
        goto    Fun1
        return     
                
FuncQuit:
        clrf  TnOutFlag      ;go back to ops mode
        clrf  ModeFl
	IF AUTOREPEAT == 1	
;	  movlw   RCol3	 	;Set Autorepeat to 3 columns	DPH
;	  movwf   RptCol	;DPH
	ENDIF
        IF DISPLAY == 204	
        goto  InitLCD
        ENDIF
        IF DISPLAY == 162
        call clkshw1
        goto showOps
        ENDIF
;------------------------------------------------
; Turnouts Control routines - Added January 2001
;------------------------------------------------
;This routine is used in Turnout Control Mode
; It will capture the keyboard from 1 to 0 and 
; enter the data into the proper accessory decoder register
; to be sent following the N or T command 
; The value is entered up to 2 digits and is replaced if overflow
; occurs - When the N or T command occurs, the number of the turnout
; is deemed to be completed.  
; Uses ACCHold1 and ACCHold2 for temporary storage and moved to
; ACCPack1 and ACCPack2 upon completion of the command N or T
;
FillT9: incf AccATemp,F 
FillT8: incf AccATemp,F
FillT7: incf AccATemp,F
FillT6: incf AccATemp,F
FillT5: incf AccATemp,F
FillT4: incf AccATemp,F
FillT3: incf AccATemp,F
FillT2: incf AccATemp,F
FillT1: incf AccATemp,F
FillT0:
        movfw AccATemp2       ;use recent first digit if there was one
        movwf AccHold1
        movwf AccHold2       ;save two copies of first digit        
        rlf   AccHold1,F ;multiply by 2               
        rlf   AccHold1,F ;multiply by 4        
        rlf   AccHold1,F ;multiply by 8        
        rlf   AccHold2,w ; digit 1 again by 2 (to get a total of 10)        
        addwf AccHold1,w ; add up
        addwf AccATemp,w ; and add-up the new digit (unit)        
        movwf AccAbcd1   ; save back in address holder
        bcf   ACCPack2,0    ;Switch in Normal (through) position 
        bcf   AccTemp2,0    ;replicate to prevent query from sending info
        movfw AccAtemp
        movwf AccAtemp2  ; save initial digit for next round
        clrf  AccATemp   ; clear for next key press.
        return
;-------------------------------------------------------
        IF  DISPLAY == 204
ShowTNumberR
        movlw   LcdLine3     ;Move cursor to third line
        call    LCDLIN 
        movlw   'R'
        call    LCDOut
        movlw   'e'
        call    LCDOut 
        movlw   'c'
        call    LCDOut
        movlw   '.'
        call    LCDOut
        goto    ShowTNum1

ShowTNumberP
        btfss   TnOutFlag,0  ;Skip the writing if not in play seq mode
        return
        btfsc   TnOutFlag,3  ;skip while in function mode as well
        return
        movlw   LcdLine3     ;Move cursor to third line
        call    LCDLIN 
        movlw   'P'
        call    LCDOut
        movlw   'l'
        call    LCDOut 
        movlw   'a'
        call    LCDOut
        movlw   'y'
        call    LCDOut
ShowTNum1
        call    LCDspace
        movlw   'R'
        call    LCDOut
        movlw   'o'
        call    LCDOut 
        movlw   'u'
        call    LCDOut
        movlw   't'
        call    LCDOut
        movlw   'e'
        call    LCDOut
        call    LCDSpace
        
        movfw   AccRoute
        call    LCDOut
	call    LCDSpace
        movfw   AccTNum
        call    Bcd1
        call    LCDSpace         
        
  
        movfw   AccAbcd1
        andlw   b'01111111'   ;Remove R marking before showing address
        call    Bcd1
        movlw   '|'      ;assume Neutral (through) at first
        btfsc   AccAbcd1,7 ; Firs bit address 2 holds action flag and last bit of this one
        movlw   '/'
        call    LCDOut
        goto    MemLeft     ;show memory left on last line for 20x4 displays
        ENDIF

        IF DISPLAY == 162
ShowTNumberR
        movlw   LcdLine1     ;Move cursor to line ONE
        call    LCDLIN 
        movlw   'R'
        call    LCDOut
        movlw   'e'
        call    LCDOut 
        movlw   'c'
        call    LCDOut       
        goto    ShowTNum1

ShowTNumberP
        btfss   TnOutFlag,0  ;Skip the writing if not in play seq mode
        return
        btfsc   TnOutFlag,3  ;skip while in function mode as well
        return
        movlw   LcdLine1     ;Move cursor to third line
        call    LCDLIN 
        movlw   'P'
        call    LCDOut
        movlw   'l'
        call    LCDOut        
        movlw   'y'
        call    LCDOut
ShowTNum1
        call    LCDspace
        movlw   'R'
        call    LCDOut
        movlw   't'
        call    LCDOut
        movlw   'e'
        call    LCDOut
        call    LCDSpace
        
        movfw   AccRoute
        call    LCDOut
	call    LCDSpace
        movfw   AccTNum
        call    Bcd1
        call    LCDSpace         
        
  
        movfw   AccAbcd1
        andlw   b'01111111'   ;Remove R marking before showing address
        call    Bcd1
        movlw   '|'      ;assume Neutral (through) at first
        btfsc   AccAbcd1,7 ; Firs bit address 2 holds action flag and last bit of this one
        movlw   '/'
        call    LCDOut
        goto    MemLeft     ;show memory left on last line for 20x4 displays
        ENDIF
        
;------------------------------------------
; This routine will move to the next Sequence number up to and including the next Zero
;   and then stop at the next zero for inclusion of next instruction if desired.

SeqUp   btfsc TnOutFlag,2     ;See if we had zero before as well
        return                ;do not allow past first set of zero                    
        incf  AccTNum,F
RU1:    movlw SeqMem-PMBase-1
        addwf AccTnum,W
        addwf AccTDelta,W     ;add the difference between origin and actual route sequence
        call  GetPrm
        movf  GetTmp,F        ;check for zero if so stop incrementing (will increment route later)
        btfsc Status,Z
        bsf   TnOutFlag,2     ;Set bit 2 to show we have been here before           
        movwf AccABcd1
        return
SeqDown
        bcf   TnOutFlag,2     ;reset Zero detection flag for now
        decfsz AccTNum,f        
        goto RU1
        incf  AccTNum,F
        return                ;stay at 1 - do not decrement.                  
        
;---------------------------------------
IncRoute
        movfw  AccRoute
        xorlw  'Z'
        btfsc  Status,Z
        return
        incf   AccRoute,F
        goto   CalcDelta  

DecRoute
        movfw  AccRoute
        xorlw  'A'
        btfsc  Status,Z
        return
        decf  AccRoute,F
        goto  CalcDelta        
;---------------------------------------
; CalcDelta() This routine parses the memory block and fetches the first significant
; sequence based on the route number - it sets the ACCDelta to the proper value
; for the sequence to begin at 1 with a delta according to the route
; The routine aborts if it reaches the end of memory before finding a Zero indicating
; the end of a sequence.
; 
;-------------------------
CalcDelta
        bcf   TnOutFlag,2      ;clear the sequence blocking flag
        clrf   ACCTDelta       ;assume Delta is zero at beginning
        movlw  'A'             ; One character before A (@)
        subwf  AccRoute,W
        btfsc  Status,Z
        goto   Cal2            ; go back - this is route a and delta is 0
        movwf  AccRCount       ;0 for Route A, 1 for Route B, etc...                            
        
cal1:   movlw  SeqMem-PMBase   ;Start at beginning of EEROM memory sequence
        addwf  ACCTDelta,W       ;add delta to sequence
        call   GetPrm
        incf   AccTDelta,F
        movf   GetTmp,F        ;check for first zero in sequence (start of next route!)
        btfss  Status,Z
        goto   Cal1            ;continue parsing 
        decfsz AccRCount,F
        goto   Cal1            ;continue until ACCRoute count is zero                             
Cal2:   
                               ;This is the end of the parsing go adjust delta
        movlw  .1              ;AccTDelta has the proper offset
        movwf  AccTNum
        movlw  SeqMem-PMBase   ;Start at beginning of EEROM memory sequence
        addwf  ACCTDelta,W     ;add delta to sequence
        call   GetPrm     
        movwf  AccABcd1         ;show value on display 
        return        
;-----------------------------------
; MemLeft() Parses the EEROM and reports the number of memory bytes left
;  Does not account for the memory lost between route (00)
;

MemLeft
        movlw  AccMemory
        movwf  AccTMem         ;maximum of AccMemory (currently 123)
        movwf  Store2
        movlw  SeqMem-PMBase   ;Start at beginning of EEROM memory sequence
        movwf  Store1       
mem1:   movfw  Store1
        call   GetPrm          ;fetch memory EEROM info
        movf   GetTmp,F        ; Check for <> 0
        btfss  Status,Z
        decf   AccTMem,F       ;reduce memory count for every location <>0
        incf   Store1,F        ;Seek next memory location
        decfsz Store2,F          ;Are we at the end of the memory block
        goto   Mem1
        IF DISPLAY == 204
         movlw  LCDLine4
        ENDIF
        IF DISPLAY == 162
         movlw  LCDline2
        ENDIF
        call   LCDlin
        movlw  '['
        call   LCDout
        movfw  AccTMem         ;Show amount of memory left on line 4
        call   bcd2        
        movlw  ']'
        goto   LCDOut
;---------------------------------
; This routine stores the route segment into EEROM
; and increments the Turnout Number for the next input
; it also clears the display showing Turnout Address
; If called at the end of a sequence with a value <>0, it 
; appends the data and move all the other memory location one step 
; to the right.  If called with a value of <0>, it erases the
; present value and moves everything one step to the left in order
; to prevent fragmentation.  If called with a value <>0 within a
; sequence, it replaces the underlying information with the 
; new one.  There is therefore no fragmentation introduced and no need for
; garbage collection.

TurnoutMem
        movf  AccABcd1,F     ;is this a zero
        btfsc Status,Z
        goto  Tur1           ;If zero, then erase underlying info and move all left one step
        btfsc AccPack2,0     ;See if N or R
        bsf   AccABcd1,7     ;replicate in AccAbcd1
Tur2:    

        movlw SeqMem-PMBase-1
        addwf AccTnum,W
        addwf AccTDelta,w
        movwf AccT1          ;Save address to store memory value for later
        call  GetPrm         ;See if value of present location is a valid value or zero
        movf  GetTmp,F
        btfsc Status,Z        
        call  MoveF          ;make room for new value - return with original position in W
	movfw AccABcd1
        movwf SavTmp1        ; Data in here for SetMem routine W has address
        movfw AccT1          ;put back address in W for storing in EEROM
        call  SetPrm
        ;call  MemLeft       ;show memory left on display (for 4X20 only)
        bcf   TnOutFlag,2    ;allow for sequence to go up even following a zero
        goto  SeqUp

Tur1:   movlw SeqMem-PMBase-1
        addwf AccTnum,W
        addwf AccTDelta,w
        movwf AccT1          ;Save address to store memory value for later
        call  GetPrm         ;Get value of present location - if zero skip the move
        movf  GetTmp,F
        btfss Status,Z       ;Is it zero? if yes skip
        call  MoveB          ;call move backward - bring back all data by one location
        return


;-----------------------------------
; MoveF() moves a number of memory location one to the right and MoveB() moves them left
; The move is non-destructive as the next value is saved in memory while the new value is
; inserted in the vacated location and so on until all have been moved.
; The routine is entered with W being set at the initial address to vacate. It will move
; all remaining memory block one location to the right (or left).
; On entry, the routine calculates how many bytes to move (MaxMem-W)
;
; 
MoveF
        
       
        movfw  AccT1        ;Place present position in W
        sublw  .128         ;Subtrack W from literal (full memory)
        movwf  AccT2        ;This is the total number of bytes to move forward
        movlw  .128          ;end of memory
        movwf  Newloops2
        movfw  NewLoops2     ;Show position at end of move        
Mov1:   decf   NewLoops2,F    ;Start at 1 less end of memory
        movfw  NewLoops2     ;put back in W register 
        call   GetPrm         ;Get first value to move
        movwf  SavTmp1
        incf   NewLoops2,W   ;increment the counter but put the value in W
        call   SetPrm        ;save previous location in next location
        decfsz AccT2,F
        goto   Mov1          ;continue moving      
        return

MoveB
        movfw  AccT1        ;Place present position in W
        sublw  .128         ;Subtrack W from literal (full memory)
        movwf  AccT2        ;This is the total number of bytes to move forward
        movfw  AccT1        ;Beginning of memory to move backward
        movwf  Newloops2
        movfw  NewLoops2     ;Show position at end of move        
Mov2:   incf   NewLoops2,F    ;Start at 1 plus present position
        movfw  NewLoops2     ;put back in W register 
        call   GetPrm         ;Get first value to move
        movwf  SavTmp1
        decf   NewLoops2,W   ;decrement the counter but put the value in W
        call   SetPrm        ;save previous location in next location
        decfsz AccT2,F
        goto   Mov2          ;continue moving
        goto   Ru1      
        ;return   
;----------------------------------------------------------
LCDClear
	clrf  rsline   ;clear for instruction send next
        movlw b'00000001' ; clear display
        call  LCDOut
	goto  pausit      ;wait 15ms before continuing        
;==================================================
; This is the entry point for the Turnout control mode
; If we try to get here twice, we want Function mode so dispatch to it
; If we come back again, then we want to revert to operations mode

TurnCont
        ;bcf   KeyFlag,EStopON 	;re-enable keyboard (if emergency stop) 
	IF AUTOREPEAT == 1						
;	  movlw   RCol3 	;Set Autorepeat to 0 columns	
;	  movwf   RptCol	;DPH
	ENDIF	  
	btfsc KeyFlag,DebnceOn
        return
        bsf   KeyFlag,DebnceOn  ;set debounce flag
        movlw .4
        movwf Debnce 
        ;incf  TnOutFlag,F       
        btfss TnOutFlag,0  	;are we already in turnout mode? yes - go Function mode
        goto  ToMode 
        goto  FuncMode       

        IF DISPLAY == 204
ToMode: call  LCDClear   ;clear display
        bsf   TnOutFlag,0        
        call  ShowHead
        movlw   LcdLine2   ;Move cursor to second line
        call    LcdLin
        clrf    loops
        
Tm1:    movfw   loops      ;initiate W register for table lookup
	call    PMMsg6     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    ShowTNumberP
        call    LCDOut       
        goto    Tm1
        ENDIF
        IF DISPLAY == 162
ToMode: call  LCDClear   ;clear display
        bsf   TnOutFlag,0        
        ;call  ShowHead
        ;movlw   LcdLine2   ;Move cursor to second line
        ;call    LcdLin
        ;clrf    loops
        
;Tm1:    movfw   loops      ;initiate W register for table lookup
	;call    PMMsg6     ;W will contain first character
        ;incf    loops,F
        ;addlw   .0
        ;btfsc   Status,Z
        goto    ShowTNumberP
        ;call    LCDOut       
        ;goto    Tm1
        ENDIF

; Special Record mode for Turnouts
;-----------------------------------------------------------
; This is the programming mode (recording sequence mode)
; for turnouts 
; Routes and Sequence number are available
; with Saving value replacing the Play button in the play mode
;
;----------------------------------------
       IF DISPLAY == 204
Pgm4:   
      

        call  LCDClear   ;clear display        
        bsf   TnOutFlag,1  ;flag recording mode for turnout       
        call  ShowHead
        movlw   LcdLine2   ;Move cursor to second line
        call    LcdLin
        clrf    loops
        
Tm2:    movfw   loops      ;initiate W register for table lookup
	call    PMMsg6     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    ShowTNumberR
        call    LCDOut       
        goto    Tm2
        ENDIF

        IF DISPLAY == 162
Pgm4:   
      

        call  LCDClear   ;clear display        
        bsf   TnOutFlag,1  ;flag recording mode for turnout       
;        call  ShowHead
;        movlw   LcdLine2   ;Move cursor to second line
;        call    LcdLin
;        clrf    loops
        
;Tm2:    movfw   loops      ;initiate W register for table lookup
;	call    PMMsg6     ;W will contain first character
;        incf    loops,F
;        addlw   .0
;        btfsc   Status,Z
        goto    ShowTNumberR
;        call    LCDOut       
;        goto    Tm2
        ENDIF

;----------------
;This routine checks for either immediate action request (asking for | or / toggle 
; and Turnout #)
; or if the DoSeqFlag is set, retrieves the sequence from EEROM and plays it back between
; speed and function control.  Il issues the turnout sequence with enough delay
; in between outputs to allow for Condenser discharge system to recharge (appx 1 second)
; The Sequencing routine uses the counter TurnCounter to increment up to a preset value and
; fetch the next sequence instruction until the end of the sequence is reached (00).
; If more than one route exists, it repeats same for next route until all routes are
; played back.
;-------------------------------------------------------
AccQuery
        btfsc DoSeqFlag,0
        goto  DoSeqNow   ;start sequence playback
        movfw ACCTemp1   ;go do immediate command but do not allow repeat commands
        subwf AccPack1,W
        btfss STATUS,Z   ;Has ACCpack2 changed since last call?
        goto  ACCSend
        movfw AccTemp2
        subwf AccPack2,w
        btfss Status,Z
AccSend:
        call  SendAccTC 
        btfss TnOutFlag,1  ;In Record Mode?    
        goto  ShowTNumberP ;update display with turnout status
        goto  ShowTNumberR        
;-----------------------------------------------
; This routine actually sends the command as DCC signal

SendAccTC
        movfw   ACCPack1
        movwf   ACCTemp1    ;save last sent pack for verification later
        movfw   ACCPack2
        movwf   AccTemp2
        call    Preamble        
        movfw   ACCPack1   
        movwf	byte1bf        
	movwf	txByte
	call	ByteTx
	call	DCCZero
        movfw   ACCPack2   ;bank 0/Turnout 0 Activate 
        movwf	byte2bf        
	movwf	txByte
	call	ByteTx
	;call	DCCZero
        clrf    byte3bf
        clrf    byte4bf         ;reset those 2 - 1 and 2 always used
        goto    ErrorByte 

;--------------------------------------------------------
DoSeqNow
        movf    TurnCount,f ;Is this the initial pass? (TurnCount is 0)
        btfss   Status,Z                            
        goto    CTcount       ;Skip initialisation
        movlw   SeqMem-PMBase ;if so then initiate sequence counter index in EEROM
        addwf   ACCTDelta,W   ;Add the delta depending on route number
        movwf   NewLoops2          ;point variable towards beginning of sequence
        clrf    ACCTNum                      
CTcount:
        incf    TurnCount,F ;move Turnout Counter by one
        movfw   TurnCount   ;see where we are in the delay
        xorlw   TurnDelay
        btfss   Status,Z    ;have we reach the maximum count?
        return              ;go back and wait for a while
                            ;Ok to start or continue sequence output
        clrf    TurnCount   ;reset turn counter
        incf    TurnCount,F ;add one to show not end of sequence yet        
DoSeq2:        
        movfw   NewLoops2
        call    GetPrm
        incf    NewLoops2,f        ;point towards next sequence - Save index EEROM
        movf    GetTmp,f           ;GetTmp has value as well as W   
        btfsc   Status,Z           
        goto    DoSeqEnd           ;yes, Zero flag is set - finish      
        incf    ACCTNum,F          ;move sequence number up by one  
        goto    SendSeq            ;send individual sequence turnout code            
                                   ;go back to normal command    
        

SendSeq                           ;prepares the packet for sending info to turnout
        movwf   AccAbcd1          ;move W to normal turnout address (BCD)        
        btfss   GetTmp,7           ;Check if T or N
        goto    ACCDnSeq          ;go do N sequence
        call    ACCdt
SendSe2       
        call    DCCIdle
        goto    ACCSend        

ACCDnSeq
        call    ACCDn
        goto    SendSe2     

DoSeqEnd
        bcf     DoSeqFlag,0        ;reset sequence request flag job done! 
        clrf    TurnCount          ;reset sequence delay counter
        movf    AccTNum,F
        btfsc   Status,Z           ;If no sequence to send then move AccTNum back to 1
        incf    AccTNum,F
        return       
;---------------------
; This routine translates the values in AccPack1 and AccPack2 from the keyboard
; to the proper register for the accessory decoder function.
ACCDn           ;(N for Through)
       bcf   ACCPack2,0    ;Switch in Normal (through) position 
       bcf   AccAbcd1,7    ;Adjust coded address for display      
ACCDn1 movfw AccAbcd1      ;remember original address
       addlw .3            ;add 3 to base address
       movwf AccHold1      
       clrf  AccPack1
       bsf   AccPack1,7    ;reset Packet 1       
       bcf   AccPack2,1
       bcf   AccPack2,2    ;assume bank 0 address 0
       bcf   Status,C      ;clear carry before rotate to avoid error
       rrf   AccHold1,F    ;Rotate 1 
       btfsc Status,C      ;check carry flag
       bsf   AccPack2,1    ;set address of bank0
       bcf   Status,C  
       rrf   AccHold1,F    ;Rotate 2
       btfsc Status,C
       bsf   AccPack2,2    ;reproduce address for Bank 0 and 1
       bcf   Status,C  
       rrf   AccHold1,F    ;Rotate 3
       btfsc Status,C
       bsf   AccPack1,0    ;reproduce address for Bank 0 and 1
       bcf   Status,C  
       rrf   AccHold1,F    ;Rotate 4
       btfsc Status,C
       bsf   AccPack1,1    ;reproduce address for Bank 0 and 1
       bcf   Status,C  
       rrf   AccHold1,F    ;Rotate 5
       btfsc Status,C
       bsf   AccPack1,2    ;reproduce address for Bank 0 and 1
       bcf   Status,C  
       rrf   AccHold1,F    ;Rotate 6
       btfsc Status,C
       bsf   AccPack1,3    ;reproduce address for Bank 0 and 1
       bcf   Status,C  
       rrf   AccHold1,F    ;Rotate 7
       btfsc Status,C
       bsf   AccPack1,4    ;reproduce address for Bank 0 and 1
       return
;------------------
; This is the entry point for R mode
ACCDt            ;(T for Turn - right or left)
       bsf   ACCPack2,0    ;Switch in R mode (turn right or left) or thrown 
       bsf   ACCAbcd1,7      
       goto  ACCDn1


;--------------------------------------
; This routine clears the SpeedRegister and preset them to forward direction
; either for 14/28 or 128 speed - The entry CLRBCD retains direction status only
ClrBcd2

        movlw   b'01100000'     ;Preset 14/28 speed forward 
        btfsc   spdflag,StepFlag5                      
        movlw   b'10000000'     ;Preset 128 speed step
        movwf   spdir1
        movlw   b'01100000'     ;Preset 14/28 speed forward 
        btfsc   spdflag,StepFlag6                      
        movlw   b'10000000'     ;Preset 128 speed step
        movwf   spdir2
        movlw   b'01100000'     ;Preset 14/28 speed forward 
        btfsc   spdflag,StepFlag7                      
        movlw   b'10000000'     ;Preset 128 speed step
        movwf   spdir3
        movlw   b'01100000'     ;Preset 14/28 speed forward 
        btfsc   spdflag,StepFlag8                      
        movlw   b'10000000'     ;Preset 128 speed step
        movwf   spdir4
        clrf    RevFlag         ;preset revflag to forward for LCD indication
ClrBcd:
        movlw   b'11100000'     ;retain bit 7 status for 128 step (ignored by 14/28 mode)
        andwf   spdir1,F
        andwf   spdir2,F
        andwf   spdir3,F
        andwf   spdir4,F       ;retain direction status        
        btfss   spdflag,StepFlag1
        bsf     spdir1,4
        btfss   spdflag,StepFlag2
        bsf     spdir2,4        
        btfss   spdflag,StepFlag3
        bsf     spdir3,4
        btfss   spdflag,StepFlag4
        bsf     spdir4,4 
        movlw   b'10000000'    ; and for 128 steps forget above and do this instead
        btfsc   spdflag,StepFlag5
        andwf   spdir1,F
        btfsc   spdflag,StepFlag6
        andwf   spdir2,F
        btfsc   spdflag,StepFlag7
        andwf   spdir3,F
        btfsc   spdflag,StepFlag8
        andwf   spdir4,F       
        clrf    bcdspd1
        clrf    bcdspd2
        clrf    bcdspd3
        clrf    bcdspd4
        clrf    bcdmsb     
        return
;---------------------------------------------------------------
        IF DISPLAY == 204
Pgm1:   

        movlw   LcdLine2 ;Move cursor to second line
        call    LcdLin
        clrf    loops       
Pgg1:   movfw   loops      ;initiate W register for table lookup
	call    PMMsg1  ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    AddLn2
        call    LCDOut       
        goto    Pgg1

AddLn2: movlw   LcdLine3 ;Move cursor to third line
        call    LCDLIN      
                            ;dt "Addr 00 00 00 00" (style)
        movlw   'A'
        call    LcdOut
        movlw   'd'
        call    LcdOut
        movlw   'd'
        call    LcdOut
        movlw   'r'
        call    LcdOut
        movlw   ' '
        btfss   spdflag,StepFlag1
        movlw   '<'  ;b'01100000'   ; \
        btfsc   spdflag,StepFlag5   ;is it 128 step?
        movlw   '>'  
        call    LcdOut       

        movfw   loco1ad
        call    Bcd2
        movlw   ' '
        btfss   spdflag,StepFlag2
        movlw   '<'   ;b'01100000'   ; '\'
        btfsc   spdflag,StepFlag6   ;is it 128 step?
        movlw   '>' 
        call    LcdOut   

        movfw   loco2ad
        call    Bcd2
        movlw   ' '
        btfss   spdflag,StepFlag3
        movlw   '<'   ;b'01100000'
        btfsc   spdflag,StepFlag7   ;is it 128 step?
        movlw   '>'  
        call    LcdOut   

        movfw   loco3ad
        call    Bcd2
        movlw   ' '
        btfss   spdflag,StepFlag4
        movlw   '<'   ;b'01100000'
        btfsc   spdflag,StepFlag8   ;is it 128 step?
        movlw   '>' 
        call    LcdOut   

        movfw   loco4ad
        goto    Bcd2            ;save last return by going direct
        ENDIF

        IF DISPLAY == 162
Pgm1:   

        movlw   LcdLine1 ;Move cursor to  line 1
        call    LcdLin
        clrf    loops       
Pgg1:   movfw   loops      ;initiate W register for table lookup
	call    PMMsg1  ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    AddLn2
        call    LCDOut       
        goto    Pgg1

AddLn2: movlw   LcdLine2 ;Move cursor to second line
        call    LCDLIN      
                            ;dt "Addr 00 00 00 00" (style)
        movlw   'A'
        call    LcdOut
        movlw   'd'
        call    LcdOut
        movlw   'd'
        call    LcdOut
        movlw   'r'
        call    LcdOut
        movlw   ' '
        btfss   spdflag,StepFlag1
        movlw   '<'  ;b'01100000'   ; \
        btfsc   spdflag,StepFlag5   ;is it 128 step?
        movlw   '>'  
        call    LcdOut       

        movfw   loco1ad
        call    Bcd1
        movlw   ' '
        btfss   spdflag,StepFlag2
        movlw   '<'   ;b'01100000'   ; '\'
        btfsc   spdflag,StepFlag6   ;is it 128 step?
        movlw   '>' 
        call    LcdOut   

        movfw   loco2ad
        call    Bcd1
        movlw   ' '
        btfss   spdflag,StepFlag3
        movlw   '<'   ;b'01100000'
        btfsc   spdflag,StepFlag7   ;is it 128 step?
        movlw   '>'  
        call    LcdOut   

        movfw   loco3ad
        call    Bcd1
        movlw   ' '
        btfss   spdflag,StepFlag4
        movlw   '<'   ;b'01100000'
        btfsc   spdflag,StepFlag8   ;is it 128 step?
        movlw   '>' 
        call    LcdOut   

        movfw   loco4ad
        goto    Bcd1            ;save last return by going direct
        ENDIF

;-----------------------------------------------------------
; Direct CV Programming LCD Readout
;----------------------------------------
        IF DISPLAY == 204
Pgm2:   

        movlw   LcdLine2 ;Move cursor to line 2
        call    LcdLin
        clrf    loops
       
Pg2:    movfw   loops      ;initiate W register for table lookup
	call    PMMsg2     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    AddCv1
        call    LCDOut       
        goto    Pg2
AddCv1: incf    bcdspd3,F   ;pre-set page register to 1
AddCv2: movlw   LcdLine3     ;Move cursor to third line
        call    LCDLIN
                        ;   "Service Mode Pag/Reg"
        movlw   'C'     ;dt "CV:000 Val:000 00-00"
                        ;   "CV:002=000 
        call    LcdOut
        movlw   'V'
        call    LcdOut
        movlw   ':'
        call    LcdOut
        movfw   bcdmsb
        movwf   msb             ;adjust msb for proper display
        movfw   bcdspd1
        addlw   .1
        call    Bcd2            ;CV# with 1 added (CV#1=00000000)
        movlw   ' '     
        call    LcdOut
        movlw   'V'     
        call    LcdOut
        movlw   'a'     
        call    LcdOut;
        movlw   ':'     
        call    LcdOut
        movfw   bcdspd2         ;CV data - leave as shown 0=0
        call    Bcd2
        call    LcdSpace

        movfw   bcdspd3
        ;addlw   .1               ;normalize to 1               

        call    bcd2              ;show page# greater than 99
        movlw   '-'
        call    LcdOut      

        movfw   bcdspd4
        goto    Bcd1            ;Show them on LCD as Register#
                                ;On exit spd3 has page and spd4 has reg.
        ENDIF

        IF DISPLAY == 162
Pgm2:   

        movlw   LcdLine1 ;Move cursor to line 1
        call    LcdLin
        clrf    loops
       
Pg2:    movfw   loops      ;initiate W register for table lookup
	call    PMMsg2     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    AddCv1
        call    LCDOut       
        goto    Pg2
AddCv1: incf    bcdspd3,F   ;pre-set page register to 1
AddCv2: movlw   LcdLine2     ;Move cursor to second line
        call    LCDLIN
                        ;   "Service Mode Pag/Reg"
        movlw   'C'     ;dt "CV:000 Val:000 00-00"
                        ;   "CV:002=000 
        call    LcdOut
        movlw   'V'
        call    LcdOut
        movlw   ':'
        call    LcdOut
        movfw   bcdmsb
        movwf   msb             ;adjust msb for proper display
        movfw   bcdspd1
        addlw   .1
        call    Bcd2            ;CV# with 1 added (CV#1=00000000)
        movlw   '-'     
        call    LcdOut
        movfw   bcdspd2         ;CV data - leave as shown 0=0
        call    Bcd2
        call    LcdSpace

        movfw   bcdspd3
        ;addlw   .1               ;normalize to 1               

        call    bcd1              ;show page# greater than 99
        movlw   '-'
        call    LcdOut      

        movfw   bcdspd4
        goto    Bcd1            ;Show them on LCD as Register#
                                ;On exit spd3 has page and spd4 has reg.
        ENDIF
;--------------------------------------------------------------
Pgm3:   call    ClrBcd2          ;reset speed registers 
        clrf    ModeFl          ;revert to Ops Mode
        clrf    loops           ;five values to save 
        clrf    TnOutFlag       ;reset all turnout flags (rec and playback)       
        movlw   Loco1Ad         ;Save Loco1 to 4 and SpeedFlag (in reverse)
        movwf   FSR
PgmS1:  movfw   INDF
        movwf   SavTmp1
        movfw   loops        
        call    SetPrm
        incf    FSR,f
        incf    loops,f
        movlw   b'00000101'     ;have we reached 5 yet
        xorwf   loops,w
        btfss   Status,Z
        goto    PgmS1
        call    LCDClear
        call    ClkShw1
        IF DISPLAY == 204     
        call    ShowOps           
        goto    ShowHead
        ENDIF
        IF DISPLAY == 162
        goto    ShowOps         ;Skip heading in 16x2 display
        ENDIF

;--------------------



EraseLine
        call    LCDlin        ;move to line to be erased
        IF DISPLAY == 204
        movlw   .20           ; erase 20 characters
        ENDIF
        IF DISPLAY == 162
        movlw   .16           ; erase 16 characters
        ENDIF
        movwf   NewLoops
Erase1: call    LCDSpace
        decfsz  NewLoops,F
        goto    Erase1
        return
;----------------------------------------------
; Keyboard decoding function dispatch                
;---------------------------------------------------------------
FL1:    btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F4_1                  			;digit ENT
        btfsc   TnOutFlag,0				;Turn (T)	
        goto    Tout41
        btfsc   TnOutFlag,1   ;record mode?
        goto    Tout41R	
        movf    ModeFl,F
        btfss   Status,Z
        goto    SetSpeed1              
        movlw	b'00010000'	;Turns Lights ON/OFF 
        btfsc   SpdFlag,StepFlag5         
        goto    Fl11
        btfss   SpdFlag,StepFlag1       ; 0 ->14   1->28 steps              
        xorwf   spdir1,f              
Fl11:	xorwf	fung1_1,f		;toggle headlights on or off
        return
SetSpeed1:
        btfsc   ModeFl,1
        return                  ;cv mode no action
        btfss   ModeFl,0
        return  
        bsf     fung1_1,FlFlag

        btfsc   spdFlag,StepFlag1   ;are we in 28 step if yes goto 14 else check mode
        goto    s14_1
        btfsc   spdFlag,StepFlag5   ;are we in 128 step if yes goto 28
        goto    s28_1
        bsf     SpdFlag,StepFlag5   ;indicate 128 mode
        goto    AddLn2
s14_1:  bcf     SpdFlag,StepFlag1
        goto    S_1
s28_1:  bcf     SpdFlag,StepFlag5
        bsf     SpdFlag,StepFlag1       
s_1:    bcf     spdir1,4
        btfss   SpdFlag,StepFlag1        
        bsf     spdir1,4
        goto    AddLn2
Tout41: 
        bsf    DoSeqFlag,0          ;flag that we want to issue sequence
        clrf   TurnCount            ;reset turnout counter
        return           
Tout41R:
        goto    TurnoutMem     ;save value in memory for sequencing
F4_1    movlw   b'00001000'
        xorwf   fung1_1,f
        goto    FunUp          ;update display
        
        
;---------------------------------------------------------------
FL2:							;digit <-
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F4_2 
        btfsc   TnOutFlag,0
        goto    Tout42
        btfsc   TnOutFlag,1  ; rec mode
        goto    Tout42R
        movf    ModeFl,F
        btfss   Status,Z
        goto    SetSpeed2   
        movlw	b'00010000'
        btfsc   SpdFlag,StepFlag6        
        goto    Fl21
        btfss   spdflag,StepFlag2     
        xorwf   spdir2,f   		
Fl21:	xorwf	fung1_2,f
        return
SetSpeed2:

        btfsc   ModeFl,1
        return                  ;cv mode no action
        btfss   ModeFl,0
        return  
        bsf     fung1_2,FlFlag

        btfsc   spdFlag,StepFlag2   ;are we in 28 step if yes goto 14 else check mode
        goto    s14_2
        btfsc   spdFlag,StepFlag6   ;are we in 128 step if yes goto 28
        goto    s28_2
        bsf     SpdFlag,StepFlag6   ;indicate 128 mode
        goto    AddLn2
s14_2:  bcf     SpdFlag,StepFlag2
        goto    S_2
s28_2:  bcf     SpdFlag,StepFlag6
        bsf     SpdFlag,StepFlag2       
s_2:    bcf     spdir2,4
        btfss   SpdFlag,StepFlag2        
        bsf     spdir2,4
        goto    AddLn2


       
Tout42:          
        
Tout42r:goto    DecRoute        ;decrement Route value (A-Z)     
F4_2    movlw   b'00001000'
        xorwf   fung1_2,f
        goto    FunUp          ;update display       
;---------------------------------------------------------------
FL3:							;digit PRT
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F4_3 
        btfsc   TnOutFlag,0
        goto    Tout43
        btfsc   TnOutFlag,1
        goto    Tout43R
        movf    ModeFl,F
        btfss   Status,Z
        goto    SetSpeed3

        movlw	b'00010000'
        btfsc   SpdFlag,StepFlag7        
        goto    Fl31
        btfss   spdflag,StepFlag3     
        xorwf   spdir3,f   		
Fl31:	xorwf	fung1_3,f
        return
SetSpeed3:
        btfsc   ModeFl,1
        return                  ;cv mode no action
        btfss   ModeFl,0
        return  
        bsf     fung1_3,FlFlag

        btfsc   spdFlag,StepFlag3   ;are we in 28 step if yes goto 14 else check mode
        goto    s14_3
        btfsc   spdFlag,StepFlag7   ;are we in 128 step if yes goto 28
        goto    s28_3
        bsf     SpdFlag,StepFlag7   ;indicate 128 mode
        goto    AddLn2
s14_3:  bcf     SpdFlag,StepFlag3
        goto    S_3
s28_3:  bcf     SpdFlag,StepFlag7
        bsf     SpdFlag,StepFlag3       
s_3:    bcf     spdir3,4
        btfss   SpdFlag,StepFlag3        
        bsf     spdir3,4
        goto    AddLn2       
Tout43: 
Tout43R:
        goto    IncRoute        ;increment route value
F4_3    movlw   b'00001000'
        xorwf   fung1_3,f
        goto    FunUp          ;update display                              
;---------------------------------------------------------------
FL4:							;digit O(period)
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F4_4  
        btfsc   TnOutFlag,0
        goto    TOut44
        btfsc   TnOutFlag,1
        goto    TOut44R
        movf    ModeFl,F
        btfss   Status,Z
        goto    SetSpeed4
        movlw	b'00010000'
        btfsc   SpdFlag,StepFlag8  ;skip in 128 mode        
        goto    Fl41
        btfss   spdflag,StepFlag4     
        xorwf   spdir4,f   		
Fl41:	xorwf	fung1_4,f
        return
SetSpeed4:
        btfsc   ModeFl,1
        return                  ;cv mode no action
        btfss   ModeFl,0
        return  
        bsf     fung1_4,FlFlag

        btfsc   spdFlag,StepFlag4   ;are we in 28 step if yes goto 14 else check mode
        goto    s14_4
        btfsc   spdFlag,StepFlag8   ;are we in 128 step if yes goto 28
        goto    s28_4
        bsf     SpdFlag,StepFlag8   ;indicate 128 mode
        goto    AddLn2
s14_4:  bcf     SpdFlag,StepFlag4
        goto    S_4
s28_4:  bcf     SpdFlag,StepFlag8
        bsf     SpdFlag,StepFlag4       
s_4:    bcf     spdir4,4
        btfss   SpdFlag,StepFlag4        
        bsf     spdir4,4
        goto    AddLn2


TOut44R:
TOut44: btfsc   AccPack2,0      ;Toggle N or R on turnouts
        goto    ACCDn
        goto    ACCDt
F4_4    movlw   b'00001000'
        xorwf   fung1_4,f
        goto    FunUp          ;update display           
;---------------------------------------------------------------
Dir1:                          				;digit DEP (#)
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F3_1    
        btfsc   TnOutFlag,0
        goto    Tout31        
        btfsc   TnOutFlag,1
        goto    Tout31R
        btfsc   ModeFL,1
        goto    PgmReg1         ;Toggles Direction Bit (28Speed)
        movlw   b'00100000'     ;would use bit 6 in 128 step mode
        btfsc   SpdFlag,StepFlag5
        movlw   b'10000000'      ;use bit 7 in 128 step and bit 5 in 14/28 steps
        xorwf   spdir1,f
        movlw   b'00000001'
        xorwf   RevFlag,f
        
        return

        
PgmReg1:;btfsc   ModeFl,0
        ;goto    TCv1              ;CV for turnout    
        
          
        call    DCCReset
        movfw   bcdspd3         ;has page number from LCD
        movwf   PageNo
        call    CVPagePreset
        call    DCCReset
        call    CVPhyWrite
        call    DCCReset
        movlw   .1
        movwf   PageNo
        call    CVPagePreset    ;reset to page 1 after use
        goto    DCCReset
       ; goto    Done
;TCV1    return
TOut31R:
TOut31: goto    SeqDown
F3_1    movlw   b'00000100'
        xorwf   fung1_1,f
        goto    FunUp          ;update display      
        ;return
;---------------------------------------------------------------

Dir2: 							;digit 9
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F3_2 
        btfsc   TnOutFlag,0
        goto    Tout32      
        btfsc   TnOutFlag,1
        goto    Tout32R
        btfsc   ModeFL,1
        goto    PgmReg2
        movlw   b'00100000'
        btfsc   SpdFlag,StepFlag6
        movlw   b'10000000'       ;use bit 7 in 128 step and bit 5 in 14/28 steps
        xorwf   spdir2,f
        movlw   b'00000010'
        xorwf   RevFlag,f 
        return


PgmReg2 ;btfsc   ModeFl,0
        ;goto    TCv2              ;CV for turnout      
        call    DCCReset
        movfw   bcdspd1
        movwf   bcdspd4         ;send raw CV value to Physical write
        call    CVPhyWrite
        goto    DCCReset
      ;  goto    Done
;TCv2    return
TOut32R:
TOut32: goto    FillT9
F3_2    movlw   b'00000100'
        xorwf   fung1_2,f
        goto    FunUp          ;update display                                 


;---------------------------------------------------------------
Dir3:							;digit 6
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F3_3 
        btfsc   TnOutFlag,0
        goto    Tout33
        btfsc   TnOutFlag,1
        goto    Tout33R
        btfsc   ModeFL,1        
        goto    PgmReg3
        movlw   b'00100000'
        btfsc   SpdFlag,StepFlag7
        movlw   b'10000000'       ;use bit 7 in 128 step and bit 5 in 14/28 steps
        xorwf   spdir3,f
        movlw   b'00000100'
        xorwf   RevFlag,f    
        return

        
PgmReg3:;btfsc   ModeFl,0
        ;goto    TCv3              ;CV for turnout     
        call    DCCReset      
        call    CVWriteDirect
        call    CVWriteDirect
        goto    DCCReset        
      ;  goto    Done
;TCv3   ; return        
TOut33R:
TOut33: goto    FillT6
F3_3    movlw   b'00000100'
        xorwf   fung1_3,f
        goto    FunUp          ;update display             
;---------------------------------------------------------------
;---------------------------------------------------------------
Dir4:							;digit 3
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F3_4 
        btfsc   TnOutFlag,0
        goto    Tout34
        btfsc   TnOutFlag,1
        goto    Tout34R
        btfsc   ModeFL,1        
        goto    PgmReg4 
        movlw   b'00100000'
        btfsc   SpdFlag,StepFlag8
        movlw   b'10000000'       ;use bit 7 in 128 step and bit 5 in 14/28 steps
        xorwf   spdir4,f
        movlw   b'00001000'
        xorwf   RevFlag,f
        return


        
PgmReg4:;
        ;goto    TCv4              ;CV for turnout     
        call    DCCReset      
        call    CVWriteExtendedDirect
        call    CVWriteExtendedDirect
        goto    DCCReset               
     ;   goto    Done
;TCv4    return
TOut34R:
TOut34: goto    FillT3
F3_4:   movlw   b'00000100'
        xorwf   fung1_4,f
        goto    FunUp          ;update display     
;---------------------------------------------------------------


SpdUp1: 						;digit REV(*)
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F1_1    
        btfsc   TnOutFlag,0
        goto    TOut11
        btfsc   TnOutFlag,1
        goto    Tout11R
	btfsc   ModeFL,0
        goto    LocAd1
        btfsc   ModeFL,1        ;check for CV programming mode
        goto    CvAdd1          ;if not do sped adjust routine        
        movlw   MaxSpeed28      ;default to 31
        btfss   SpdFlag,StepFlag1
        movlw   MaxSpeed14
        btfsc   SpdFlag,StepFlag5 ; next two added for 128 speed increments
        movlw   MaxSpeed128
        xorwf   bcdspd1,w       
        btfsc   STATUS,Z
        return
        incf    bcdspd1,f
        btfss   SpdFlag,StepFlag1
        goto    LcAd1           ;increment the register directly
	movlw	b'00010000'
	xorwf	spdir1,f	;toggle lsb of 28 speed
	btfss	spdir1,4	;check if lsb is zero or one
LcAd1:	incf	spdir1,f	;if clear then increment next 4 msb (0-3)	
        return
LocAd1: 
        incf    Loco1Ad,f
        call    AddLn2
        return
CvAdd1: 
	incf    bcdspd1,f        
        movlw   b'11111111'
        xorwf   bcdspd1,w
        btfsc   Status,Z         ;if we have a carry, then increment MSB register
        incf    bcdmsb,F
        incf    bcdspd4,F        ;increment reg register
        btfsc   bcdspd4,2        ;are we at 4 if so clrf and increment bcdspd3    
        goto    CvAdd22
        goto    AddCv2
CvAdd22 clrf    bcdspd4
        incf    bcdspd3,F
        goto    AddCv2

TOut11R:
TOut11: goto    SeqUp
F1_1    movlw   b'00000001'
        xorwf   fung1_1,f
        goto    FunUp          ;update display      
        ;return
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdUp2: 						;digit 7
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F2_1    
        btfsc   TnOutFlag,0
        goto    Tout12
        btfsc   TnOutFlag,1
        goto    Tout12R
	btfsc   ModeFL,0
        goto    LocAd2
        btfsc   ModeFL,1        ;check for CV programming mode
        goto    CvAdd2          ;if not do sped adjust routine

        movlw   MAXSPEED28        ;default to 31 in bcd
        btfss   SpdFlag,StepFlag2
        movlw   MaxSpeed14 
        btfsc   SpdFlag,StepFlag6 ; next two added for 128 speed increments
        movlw   MaxSpeed128
        xorwf   bcdspd2,w       
        btfsc   STATUS,Z
        return
        incf    bcdspd2,f
        btfss   SpdFlag,StepFlag2
        goto    LcAd2           ;increment the register directly
	movlw	b'00010000'
	xorwf	spdir2,f	;toggle lsb of 28 speed
	btfss	spdir2,4	;check if lsb is zero or one
LcAd2:  incf    spdir2,f
        return
LocAd2: 
        incf    Loco2Ad,f
        call    AddLn2
        return
CvAdd2: 
        incf    bcdspd2,f
        goto    AddCv2

        return
TOut12R:
TOut12: goto    FillT7
        
F2_1    movlw   b'00000001'
        xorwf   fung1_2,f
        goto    FunUp          ;update display      
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdUp3:							;digit 4
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F1_3 
        btfsc   TnOutFlag,0
        goto    Tout13
        btfsc   TnOutFlag,1
        goto    Tout13R        
	btfsc   ModeFL,0
        goto    LocAd3
        btfsc   ModeFL,1
        return
        movlw   MAXSPEED28        ;default to 15 in bcd
        btfss   SpdFlag,StepFlag3
        movlw   MaxSpeed14 
        btfsc   SpdFlag,StepFlag7 ; next two added for 128 speed increments
        movlw   MaxSpeed128
        xorwf   bcdspd3,w       
        btfsc   STATUS,Z
        return
        incf    bcdspd3,f
        btfss   SpdFlag,StepFlag3
        goto    LcAd3           ;increment the register directly
	movlw	b'00010000'
	xorwf	spdir3,f	;toggle lsb of 28 speed
	btfss	spdir3,4	;check if lsb is zero or one
LcAd3   incf    spdir3,f
        return
LocAd3: ;btfsc   ModeFl,1
        ;goto    TCvu3              ;CV for turnout     
        incf    Loco3Ad,f
        goto    AddLn2
;TCvu3   return
TOut13R:
TOut13: goto    FillT4
        
F1_3    movlw   b'00000001'
        xorwf   fung1_3,f
        goto    FunUp          ;update display      
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdUp4:                                               ;Digit 1
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F1_4 
        btfsc   TnOutFlag,0
        goto    Tout14
        btfsc   TnOutFlag,1
        goto    Tout14R
	btfsc   ModeFL,0
        goto    LocAd4
        btfsc   ModeFL,1
        return
        movlw   MAXSPEED28        ;default to 15 in bcd
        btfss   SpdFlag,StepFlag4
        movlw   MaxSpeed14
        btfsc   SpdFlag,StepFlag8 ; next two added for 128 speed increments
        movlw   MaxSpeed128 
        xorwf   bcdspd4,w       
        btfsc   STATUS,Z
        return
        incf    bcdspd4,f
        btfss   SpdFlag,StepFlag4
        goto    LcAd4           ;increment the register directly
	movlw	b'00010000'
	xorwf	spdir4,f	;toggle lsb of 28 speed
	btfss	spdir4,4	;check if lsb is zero or one
LcAd4:  incf    spdir4,f
        return
LocAd4:  
        incf    Loco4Ad,f
        goto    AddLn2

TOut14R
TOut14: goto    FillT1
F1_4    movlw   b'00000001'
        xorwf   fung1_4,f
        goto    FunUp          ;update display             
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdDn1:	
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F1_2    						;digit 0
        btfsc   TnOutFlag,0
        goto    Tout21
        btfsc   TnOutFlag,1
        goto    Tout21R
        btfsc   ModeFL,0
        goto    LocAd5
        btfsc   ModeFL,1        ;check for CV programming mode
        goto    CvSub1          ;if not do speed adjust routine

        movfw   bcdspd1
        btfsc   STATUS,Z
        return
        decf    bcdspd1,f
        btfss   SpdFlag,StepFlag1
        goto    LcAd5           ;decrement the register directly
	movlw	b'00010000'
	xorwf	spdir1,f	;toggle lsb of 28 speed
	btfsc	spdir1,4	;check if lsb is zero or one	
LcAd5:	decf	spdir1,f
        return
LocAd5: 
        decf    Loco1Ad,f
        call    AddLn2
        return
CvSub1: 
        decf    bcdspd4,F    ;decrement reg register (3,2,1,0,3...)
        btfsc   bcdspd4,2    ;check for 11111111 (255)
        call    CvS2
        decf    bcdspd1,f
        movlw   b'11111110'
        xorwf   bcdspd1,W
        btfsc   status,Z
        decf    bcdmsb,F
        movlw   b'11111111'
        xorwf   bcdmsb,W     ;check to see if we are negative in MSB
        btfsc   Status,Z
        call    CvPreset        
        goto    AddCv2
CvS2    movlw   .3
        movwf   bcdspd4    ; revert back to 3
        decf    bcdspd3,F    ; decrement pag register
        return
CvPreset
        movlw   .2           ; revert back to 0 and add two for 512 preset
        addwf   bcdmsb,F
        movwf   bcdspd4      ; preset reg to 2
        movlw   .128
        movwf   bcdspd3      ; preset to 128
        return       

TOut21R:
TOut21: goto    FillT0
F1_2    movlw   b'00000010'
        xorwf   fung1_1,f
        goto    FunUp          ;update display    
 	;return
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdDn2: 						;digit 8
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F2_2 
        btfsc   TnOutFlag,0
        goto    Tout22
        btfsc   TnOutFlag,1
        goto    Tout22R
	btfsc   ModeFL,0
        goto    LocAd6
        btfsc   ModeFL,1        ;check for CV programming mode
        goto    CvSub2          ;if not do sped adjust routine

        movfw   bcdspd2
        btfsc   STATUS,Z
        return
        decf    bcdspd2,f
        btfss   SpdFlag,StepFlag2
        goto    LcAd6           ;decrement the register directly

	movlw	b'00010000'
	xorwf	spdir2,f	;toggle lsb of 28 speed
	btfsc	spdir2,4	;check if lsb is zero or one		
LcAd6:  decf    spdir2,f
        return
LocAd6: ;btfsc   ModeFl,1
        ;goto    TCvd2             ;CV for turnout     
        decf    Loco2Ad,f
        goto    AddLn2
        ;return
CvSub2: ;btfsc   ModeFl,0
        ;goto    TCvd2              ;CV for turnout   
        decf    bcdspd2,f
        goto    AddCv2
TOut22R:
TOut22: goto    FillT8
        ;return 
F2_2    movlw   b'00000010'
        xorwf   fung1_2,f
        goto    FunUp          ;update display           
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdDn3:							;digit 5
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F2_3 
        btfsc   TnOutFlag,0
        goto    Tout23
        btfsc   TnOutFlag,1
        goto    Tout23R
	btfsc   ModeFL,0
        goto    LocAd7
        btfsc   ModeFL,1
        return
        movfw   bcdspd3
        btfsc   STATUS,Z
        return
        decf    bcdspd3,f
        btfss   SpdFlag,StepFlag3
        goto    LcAd7           ;decrement the register directly

	movlw	b'00010000'
	xorwf	spdir3,f	;toggle lsb of 28 speed
	btfsc	spdir3,4	;check if lsb is zero or one		
LcAd7:  decf    spdir3,f
        return
LocAd7: ;btfsc   ModeFl,1
        ;goto    TCvd3              ;CV for turnout     
        decf    Loco3Ad,f
        goto    AddLn2
;TCvd3   return       
TOut23R:
TOut23: goto   FillT5
F2_3    movlw   b'00000010'
        xorwf   fung1_3,f
        goto    FunUp          ;update display           
;---------------------------------------------------------------
;---------------------------------------------------------------
SpdDn4: 						;digit 2
        btfsc   TnOutFlag,3       ;Function 1 to 4
        goto    F2_4 
        btfsc   TnOutFlag,0
        goto    Tout24
        btfsc   TnOutFlag,1
        goto    Tout24R
	btfsc   ModeFL,0
        goto    LocAd8
        btfsc   ModeFL,1
        return
        movfw   bcdspd4
        btfsc   STATUS,Z
        return
        decf    bcdspd4,f
	movlw	b'00010000'
        btfss   SpdFlag,StepFlag4
        goto    LcAd8           ;decrement the register directly

	xorwf	spdir4,f	;toggle lsb of 28 speed
	btfsc	spdir4,4	;check if lsb is zero or one
LcAd8:  decf    spdir4,f
        return
LocAd8: ;btfsc   ModeFl,1
        ;goto    TCvd4              ;CV for turnout     
        decf    Loco4Ad,f
        goto    AddLn2
;TCvd4   return
TOut24R:
TOut24: goto    FillT2
F2_4    movlw   b'00000010'
        xorwf   fung1_4,f
        goto    FunUp          ;update display     
	              
;---------------------------------------------------------------


;---------------------------------------------------------------
; This routine writes to the internal EEROM - W-> address SavTmp1 -> data
;  but prevents writing if value to be the same (saves wear and tear on 
;  write cycle)

SetPrm
        movwf   SavTmp2        ;save address for later
        call    GetPrm          ;GetTmp as value
        xorwf   SavTmp1,w       ;if SavTmp1 same as GetTmp then return
        btfsc   Status,Z
        return
        movfw   SavTmp2        ;restore address and write   
        bank1
        movwf   EEADR        
        bsf     EECON1,WREN
        bcf     INTCON,GIE
        bank0
        movf    SavTmp1,w
        bank1
        movwf   EEDATA
                   ;protocole for write routine (Microchip)
        movlw   055h
        movwf   EECON2
        movlw   0aah
        movwf   EECON2
        bsf     EECON1,WR
        
ChkWrt: btfsc   EECON1,WR
        goto    ChkWrt
        bcf     EECON1,WREN        
        BSF     INTCON,GIE   ;re-enable interrupt        
        bank0
        return
;----------------------------------------
; This routine reads from the internal EEROM (W has address - GetTmp has
;  data along with W as well)

GetPrm
        bank1
        movwf   EEADR        
        bsf     EECON1,RD
        
        movf    EEDATA,w
        bank0
        movwf   GetTmp
        return

;---------------------------------------------------------------







;--------------------------------------------------------------------
InitLCD  ;This is the LCD Display 20*4 or 16*2 Initialization routine
;--------------------------------------------------------
; Set Display at 162 or 204 depending on LCD attached
;--------------------------------------------------------------------

        call    PAUSIT     ;15 ms delay before starting LCD       
LCDSET: clrf    loops      ;clr LCD set-up loop
        clrf    RSLINE     ;clear RS line for instruction send
LCDST2: movf    loops,W    ;get table address
        call    TABLCD     ;get set-up instruction
        call    LCDOUT     ;perform it
        incf    loops,F    ;inc loop
        btfss   loops,3    ;has last LCD set-up instruction now been done?
        goto    LCDST2     ;no
        
        call    PAUSIT

        ;show title here
        IF DISPLAY == 204
        call    ShowHead
        call    ClkShw1
        goto    ShowOps
        ENDIF
        IF DISPLAY == 162                
        call    ShowHead
        call    Wait2Sec     ;wait for about 2 seconds then carry on
        call    ClkShw1      ;Loc:03*... header
        goto    ShowOps
        ENDIF


;-------------
; Initial heading here
        IF DISPLAY == 204
ShowHead
        movlw   LcdLine1 ;Move cursor to Line one
        call    LcdLin
        clrf    loops
        
head1:  movfw   loops      ;initiate W register for table lookup
	call    PMMsg4     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        return
        call    LCDOut       
        goto    head1
        ENDIF
       
        IF DISPLAY == 162

ShowHead
        movlw   LcdLine1 ;Move cursor to Line one
        call    LcdLin
        clrf    loops        
head1:  movfw   loops      ;initiate W register for table lookup
	call    PMMsg4     ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        goto    head3      ;go do second line
        call    LCDOut       
        goto    head1
head3:  movlw   LcdLine2 ;Move cursor to Line two - show second line heading
        call    LcdLin
        clrf    loops        
head2:  movfw   loops      ;initiate W register for table lookup
	call    PMMsg4b    ;W will contain first character
        incf    loops,F
        addlw   .0
        btfsc   Status,Z
        return
        call    LCDOut       
        goto    head2
        ENDIF
;--------------------------------------------------------------- 
       
CLKSHW1: 
        IF DISPLAY == 204

        movlw   LcdLine2  ; move to second line
        goto    $+2
ClkShw3:
        movlw   LcdLine3  ; 3rd line for function
        call    LCDLIN          
        movlw   'L'        
        call    LCDOUT
        movlw   'o'
        call    LCDOUT  
        movlw   'c'
        call    LCDOUT
        movlw   ':'
        call    LCDOUT
        movfw   loco1ad
        call    Bcd2
        movlw   '-'
        btfsc   fung1_1,4
        movlw   '*'
        call    LCDOUT
        movfw   loco2ad
        call    Bcd2
        movlw   '-'
        btfsc   fung1_2,4
        movlw   '*'
        call    LCDOUT
        movfw   loco3ad
        call    Bcd2
        movlw   '-'
        btfsc   fung1_3,4
        movlw   '*'
        call    LCDOUT
        movfw   loco4ad
        call    Bcd2
        movlw   '-'
        btfsc   fung1_4,4
        movlw   '*'        
        goto    LCDOUT
ShowOps:

        movlw   LcdLine3     ;show time third
        call    LCDLIN  
        call    LCDSpace 
        call    LCDSpace 
        call    LCDSpace 
        call    LCDSpace      
                 
        movlw   07eh            ;b'01111110'; ->     
        
;        btfss   spdir1,DirFlag
        btfsc   RevFlag,0
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT
        movf    bcdspd1,W   ;get speed
        call    Bcd2       
 
        movlw   07eh            ;b'01111110'; ->
;        btfss   spdir2,DirFlag
        btfsc   RevFlag,1
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT

        movf    bcdspd2,W   ;get speed
        call    Bcd2


     

        movlw   07eh            ;b'01111110'; ->
;        btfss   spdir3,DirFlag
        btfsc   RevFlag,2
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT

        movf    bcdspd3,W   ;get speed
        call    Bcd2



        movlw   07eh            ;b'01111110'; ->
;        btfss   spdir4,DirFlag
        btfsc   RevFlag,3
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT

        movf    bcdspd4,W   ;get speed
        goto    Bcd2
        ENDIF

        IF DISPLAY == 162

        movlw   LcdLine1     ;Move cursor to first line   
        call    LCDLIN          
        movlw   'L'        
        call    LCDOUT
        movlw   'o'
        call    LCDOUT  
        movlw   'c'
        call    LCDOUT
        movlw   ':'
        call    LCDOUT
        movfw   loco1ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_1,4
        movlw   '*'
        call    LCDOUT
        movfw   loco2ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_2,4
        movlw   '*'
        call    LCDOUT
        movfw   loco3ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_3,4
        movlw   '*'
        call    LCDOUT
        movfw   loco4ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_4,4
        movlw   '*'        
        goto    LCDOUT

ClkShw2:
        movlw   LcdLine1     ;Move cursor to first line   
        call    LCDLIN          
        movlw   'L'        
        call    LCDOUT
        movfw   loco1ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_1,4
        movlw   '*'
        call    LCDOUT
        movlw   'L'        
        call    LCDOUT
        movfw   loco2ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_2,4
        movlw   '*'
        call    LCDOUT
        movlw   'L'        
        call    LCDOUT
        movfw   loco3ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_3,4
        movlw   '*'
        call    LCDOUT
        movlw   'L'        
        call    LCDOUT
        movfw   loco4ad
        call    Bcd1
        movlw   '-'
        btfsc   fung1_4,4
        movlw   '*'        
        goto    LCDOUT



ShowOps:

        movlw   LcdLine2     ;show time SECOND LINE
        call    LCDLIN                   
        movlw   07eh            ;b'01111110'; ->          
        btfsc   RevFlag,0
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT
        movf    bcdspd1,W   ;get speed
        call    Bcd2        
        movlw   07eh            ;b'01111110'; ->
        btfsc   RevFlag,1
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT
        movf    bcdspd2,W   ;get speed
        call    Bcd2   
        movlw   07eh            ;b'01111110'; ->
        btfsc   RevFlag,2
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT
        movf    bcdspd3,W   ;get speed
        call    Bcd2
        movlw   07eh            ;b'01111110'; ->
        btfsc   RevFlag,3
        movlw   07fh            ;b'01111111'; <-
        call    LCDOUT
        movf    bcdspd4,W   ;get speed
        goto    Bcd2
        ENDIF
;--------------------------------------------------------------        

LCDFRM: movwf   STORE2    ;split & format decimal byte for LCD
        swapf   STORE2,W  ;swap byte into W to get tens
        andlw   .15        ;AND to get nibble
        iorlw   .48        ;OR with 48 to make ASCII value
LCDZS1: call    LCDOUT     ;send to LCD
        movf    STORE2,W   ;get units
LCDFR1: andlw   .15        ;AND to get nibble
        iorlw   .48        ;OR with 48 to make ASCII value
LCDOUT: movwf   STORE1    ;temp store value that will be output to LCD
        movlw   .20        ;set minimum time between sending full bytes to
        movwf   LOOPA     ;LCD - value of 20 seems OK for this prog with
DELAY:  decfsz  LOOPA,F  ;XTAL clk of upto 5MHz, possibly 5.5MHz
        goto    DELAY
        call    SENDIT     ;send MSB, then (by default) send LSB

SENDIT: swapf   STORE1,F  ;swap byte nibbles
        movf    STORE1,W   ;get nibble (MSB)
        andlw   .15        ;AND to isolate nibble
        iorwf   RSLINE,W  ;OR the RS bit
        movwf   PORTB     ;output the byte
        bsf     PORTA,1     ;set E high  
        bcf     PORTA,1     ;set E low        
        return
Bcd1                    ;this routine writes 1 BCD to LCD display
        movwf   LSB
        call    bin2bcd
        movfw   R2
        goto    LCDFRM  ;replace call with goto

Bcd2                    ;this routine writes 2 BCD to LCD display
        movwf   LSB
        call    bin2bcd
        movfw   R1
        call    LCDFR1
        movfw   R2
        goto    LCDFRM     ;format and sent it to LCD

LCDLIN: bcf     RSLINE,4    ;sets LCD command/line
        call    LCDOUT     ;and outputs cmmand code to LCD
        bsf     RSLINE,4    ;set RS flag
        return

PAUSIT: 
	movlw	.20        ;use 10 for 15 milliseconds 10 * 1.5 ms
	movwf	loopa
Pau2:	movlw	.150
	movwf	loops
	call	t10us
	decfsz	loopa,f
	goto	Pau2
	return
	




;-------------------------------------------------------------------------

;-------------------------------------------------------------------------

       
;-------------------------------------------------------------------------
;ServiceKey, does the software service for a keyhit. After a key service,
;the ServKey flag is reset, to denote a completed operation.

ServiceKey
        
        movf    NewKey,w        ;get key value             
        call    CommandTable        
        bcf     KeyFlag,ServKey ;reset service flag
        movf    ModeFl,f
        btfss   Status,Z
        return
        btfsc   TnOutFlag,0  ;are we in turnout mode? yes - don't revert
        return
        call    CLKSHW1
        goto    ShowOps   
        

;
;
;ScanKeys, scans the 4X4 keypad matrix and returns a key value in
;NewKey (0 - F) if a key is pressed, if not it clears the keyhit flag.
;Debounce for a given keyhit is also taken care of.
;The rate of key scan is 20mS with a 4.096Mhz clock.
ScanKeys
CheckPortA
    

        btfss   PortA,2
        goto    Cestop
        btfsc   Porta,3
        goto    CheckCont

CTurnCont
        movf    ModeFl,f
        btfss   Status,Z
        goto    PgmMode1
        goto    TurnCont
       
Cestop  movf    ModeFl,F
        btfss   Status,Z
        goto    PgmMode1
        goto    Estop

        
          
CheckCont      
; Original ScanKeys routine
        
        
        btfss   KeyFlag,DebnceOn ;debounce on?
        goto    Scan1           ;no then scan keypad
        decfsz  Debnce, F       ;else dec debounce time
        return                  ;not over then return
        bcf     KeyFlag,DebnceOn ;over, clr debounce flag
;=========================copy from here==========================DPH
	IF AUTOREPEAT ==1			;					DPH
	  movlw	RDly			;init the autorepeat delay	DPH
	  movwf	RptDly		;					DPH
	  movlw	RSpd			;init the repeat rate		DPH
	  movwf	RptSpdi		;					DPH
	ENDIF					;					DPH
        return                  ;and return
Scan1   
        ;btfsc   keyFlag,EstopOn     ;Is this an emergency stop?
        ;return                      ;Yes, then disable matrix keyboard    

        call    SavePorts       ;save port values
        movlw   B'11101111'     ;init TempD
        movwf   TempD
ScanNext
        movf    PORTB,w        ;read to init port
        bcf     INTCON,RBIF     ;clr flag
        rrf     TempD, F        ;get correct column
        btfss   STATUS,C        ;if carry set?
        goto    NoKey           ;no then end
        movf    TempD,w         ;else output
        movwf   PORTB          ;low column scan line
        nop
        btfss   INTCON,RBIF     ;flag set?
	IF AUTOREPEAT == 0
        goto    ScanNext        ;no then next
        btfsc   keyFlag,keyhit  ;last key released?
        goto    SKreturn        ;no then exit
        bsf     keyFlag,keyhit  ;set new key hit
        swapf   PORTB,w        ;read port
        movwf   TempE           ;save in TempE
        call    GetKeyValue     ;get key value 0 - F
        movwf   NewKey          ;save as New key
        bsf     keyFlag,ServKey ;set service flag
        bsf     keyFlag,DebnceOn ;set flag
        movlw   .4
        movwf   Debnce          ;load debounce time
SKreturn
        goto    RestorePorts    ;restore ports
	ENDIF
	IF AUTOREPEAT == 1		;					DPH
        goto    ScanNext        ;no then next				DPH
        btfsc   keyFlag,keyhit  ;last key released?			DPH
        goto    ScanR	        ;no then is it a repeat key		DPH
	  bsf     keyFlag,keyhit  ;set new key hit			DPH
        swapf   PORTB,w        ;read port					DPH
        movwf   TempE           ;save in TempE				DPH
        call    GetKeyValue     ;get key value 0 - F			DPH
        movwf   NewKey          ;save as New key			DPH
        bsf     keyFlag,DebnceOn ;set flag				DPH
        movlw   .4		  ;						DPH
        movwf   Debnce          ;load debounce time			DPH
Scan2:  bsf     keyFlag,ServKey ;set service flag			DPH
SKreturn:
        goto    RestorePorts    ;restore ports				DPH
ScanR:				  ;						DPH
;	  movfw   TempD		;get column mask				DPH
;        andwf   RptCol,w	;isolate columns				DPH
;        xorwf   RptCol,w	;are we in column 1 or 2?		DPH
;	  btfss   STATUS, z	;if not don't repeat the key		DPH
	  decfsz  RptDly,f	;if the repeat delay not ended	DPH         
	  goto    RestorePorts	;then exit					DPH
	  movlw   RptMax		;load max repeat rate			DPH
	  subwf   RptSpdi,w	;compare to repeat rate			DPH
	  btfss   STATUS,Z	;if not equal...				DPH
	  decf    RptSpdi,f	;..then increment repeat speed	DPH
	  movfw   RptSpdi		;load repeat rate divided...		DPH
	  movwf   RptSpd		;... into the counter			DPH						DPH
	  goto    Scan2		;and do this keypress			DPH
	ENDIF									;	DPH
;=======================copy to here==============================DPH

NoKey
        bcf     KeyFlag,keyhit  ;clr flag
        goto    SKreturn
;
;GetKeyValue gets the key as per the following layout
;
;                  Col1    Col2    Col3    Col3
;                  (RB3)   (RB2)   (RB1)   (RB0)
;
;Row1(RB4)           0       1       2       3
;
;Row2(RB5)           4       5       6       7
;
;Row3(RB6)           8       9       A       B
;
;Row4(RB7)           C       D       E       F
;
GetKeyValue
        clrf    TempC
        btfss   TempD,3         ;first column
        goto    RowValEnd
        incf    TempC, F
        btfss   TempD,2         ;second col.
        goto    RowValEnd
        incf    TempC, F
        btfss   TempD,1         ;3rd col.
        goto    RowValEnd
        incf    TempC, F        ;last col.
RowValEnd
        btfss   TempE,0         ;top row?
        goto    GetValCom       ;yes then get 0,1,2&3
        btfss   TempE,1         ;2nd row?
        goto    Get4567         ;yes the get 4,5,6&7
        btfss   TempE,2         ;3rd row?
        goto    Get89ab         ;yes then get 8,9,a&b
Getcdef
        bsf     TempC,2         ;set msb bits
Get89ab
        bsf     TempC,3         ;       /
        goto    GetValCom       ;do common part
Get4567
        bsf     TempC,2
        goto    GetValCom
;
;SavePorts, saves the porta and portb condition during a key scan
;operation.
SavePorts

        movf    PORTB,w        ;get port b
        movwf   PBBuf           ;save in buffer
        movlw   0xff            ;make all high
        movwf   PORTB          ;on port b
        bank1
        bcf     OPTION_REG,7     ;enable pull ups
        movlw   B'11110000'     ;port b hi nibble inputs
        movwf   TRISB   ;&0x7f     ;lo nibble outputs
        bank0
        return
;
;RestorePorts, restores the condition of porta and portb after a
;key scan operation.
RestorePorts
        movf    PBBuf,w         ;get port n
        movwf   PORTB
        bank1
        bsf     OPTION_REG,7     ;disable pull ups
        clrf    TRISB   ;&0x7f     ;as well as PORTB
        bank0        
        return
;-------------------

;
SendDCCPulse1
	call	Preamble
	call	AddressByte1       
	goto	SpeedDirByte1       
SendDCCPulse2
	call	Preamble
	call	AddressByte2        
	goto	SpeedDirByte2          	
SendDCCPulse3
	call	Preamble
	call	AddressByte3        
	goto	SpeedDirByte3        
SendDCCPulse4
	call	Preamble
	call	AddressByte4        
	goto	SpeedDirByte4   	
      


;----------------------------------------------


AddressByte1:
	movfw	loco1ad
        goto    AddCom
AddressByte2:
	movfw	loco2ad
        goto    AddCom
AddressByte3:
        movfw   loco3ad
        goto    AddCom
AddressByte4:
        movfw   loco4ad ;just fall through AddCom
AddCom:	movwf	byte1bf        
	movwf	txByte
	call	ByteTx
	goto	DCCZero


;-------------------------------------------------------

;-------------------------------------------------------
;-------- Either 14, 28 or 128 steps depending on CV29 setup
SpeedDirByte1:
	movfw	spdir1
        btfsc   spdflag,StepFlag5
        goto    SpdCom128
        goto    SpdCom
SpeedDirByte2:
        movfw   spdir2
        btfsc   spdflag,StepFlag6
        goto    SpdCom128
        goto    SpdCom       
SpeedDirByte3:
        movfw   spdir3
        btfsc   spdflag,StepFlag7
        goto    SpdCom128
        goto    SpdCom      
SpeedDirByte4:
        movfw   spdir4
        btfsc   spdflag,StepFlag8
        goto    SpdCom128        
SpdCom:	movwf	byte2bf
	movwf	txByte
	call	ByteTx	
        clrf    byte3bf
SpdEnd: clrf    byte4bf         ;reset registers not used
        goto    ErrorByte

SpdCom128
        movwf   byte3bf
        movlw   b'00111111'     ;advanced 128 Step Speed control instruction
        movwf   byte2bf
        movwf   txByte
        call    ByteTx
        call    DccZero
        movfw   byte3bf
        movwf   txByte
        call    ByteTx
        goto    Spdend
;--------------------------------------------------------


;------------------------------------
; Function group one instruction (100)

FuncGroup1_1:
	call	Preamble
	call	AddressByte1
	movfw	fung1_1
        goto    SpdCom ;FunCom
FuncGroup1_2:
	call	Preamble
	call	AddressByte2
	movfw	fung1_2
        goto    SpdCom  ;FunCom
FuncGroup1_3:
	call	Preamble
	call	AddressByte3
	movfw	fung1_3
        goto    SpdCom  ;FunCom
FuncGroup1_4:
	call	Preamble
	call	AddressByte4
	movfw	fung1_4
        goto    Spdcom



;----------------------------------------------------------------------







;----------------------------------------------------------------


;-------------------------------------------------------
CVPagePreset            ;preset page register to 1 (sarp 9....)
                        ;Enter with PageNo set to page desired
        movlw   ServRept
        movwf   ServCnt
CVP1:   call    LongPreamble        ;dcczero built in
        movlw   b'01111101'
        movwf   txByte
        movwf   byte1bf
        call    ByteTx      ; call all registers (broadcast)    
        call    DCCZero
        movfw   PageNo        
        movwf   byte2bf
        movwf   txByte
        call    ByteTx
        ;call    DCCZero 
        clrf    byte3bf
        clrf    byte4bf         ;reset registers not used     
        call    ErrorByte
        decfsz  ServCnt,f
        goto    CVP1            ;Repeat 6 times        
        return        
        
;-----------------------------------------------
CVPhyWrite
        movlw   ServRept
        movwf   ServCnt

CVPh1:  call    LongPreamble        ;dcczero built in
        movfw   bcdspd4        ;Register number (from 0 to 3) 
        andlw   b'01111111'
        iorlw   b'01111000'        
        movwf   txByte
        movwf   byte1bf
        call    ByteTx      ; call all registers (broadcast)    
        call    DCCZero
        movfw   bcdspd2         ;
        movwf   byte2bf
        movwf   txByte
        call    ByteTx
        ;call    DCCZero
        call    ErrorByte 
        decfsz  ServCnt,f
        goto    CVPh1
        return          
;----------------------------
; 
CVWriteExtendedDirect        
        
        call    Preamble        ;dcczero built in
        clrf    txByte
        clrf    byte1bf
        call    ByteTx      ; call all registers (broadcast)    
        call    DCCZero
        movlw   b'11101100' ;Instruction byte (Write Registers)
        movwf   byte2bf
        btfsc   bcdmsb,0            ;replicate msb into W for 10 bit resolution
        bsf     byte2bf,0
        btfsc   bcdmsb,1
        bsf     byte2bf,1   

CVEntry:
        movwf   txByte          ;send byte
        call    ByteTx
        call    DCCZero
        movfw   bcdspd1         ;CV number (Real value minus one)
        movwf   byte3bf
        movwf   txByte
        call    ByteTx
        call    DCCZero
        movfw   bcdspd2         ;Value to go into CV
        movwf   byte4bf
        movwf   txByte
        call    ByteTx
        ;call    DCCZero
        goto    ErrorByte    
       

CVWriteDirect
        
        call    LongPreamble        ;dcczero built in
        clrf    byte2bf             ;not used - must clear
        movlw   b'01111100'        
        movwf   byte1bf
        btfsc   bcdmsb,0            ;replicate msb into W for 10 bit resolution
        bsf     byte1bf,0
        btfsc   bcdmsb,1
        bsf     byte1bf,1   
        goto    CVEntry

;--------------------------------------------         
   

LcdSpace
        movlw   ' '
        goto    LcdOut        
;------------------------------------------
        IF TEST == 1
SyncPulse:
	bcf  	PORTA,4
	goto $+1 ;for 3 us pulse appx use for scope sync                
	bsf	PORTA,4
	return
        ENDIF
;--------------------------------------------------


DCCReset	
	movlw	ResetRept
	movwf   STORE1
DCCR1:	call 	Preamble
	clrf	txByte
	clrf	byte1bf
	clrf	byte2bf
	call	ByteTx
	call	DCCZero
        clrf    txByte
	call	ByteTx
        clrf    byte3bf
        clrf    byte4bf         ;reset those not used
	;call	DCCZero
	call	ErrorByte	
        decfsz	STORE1,f
	goto	DCCR1
	return




;-----------------------------------------

;-------------------------------------------------------
DCCIdle	
	call	Preamble
	movlw	b'11111111'  ; all ones
	movwf	txByte
	movwf	byte1bf
	call	ByteTx
	goto	Dc1
Dc1:	goto	Dc2
Dc2:	goto	Dc3
Dc3:	nop
	call	DCCZero
	clrf	txByte
	clrf	byte2bf
	call	ByteTx
        clrf    byte3bf
        clrf    byte4bf         ;reset - not used
	;call	DCCZero
	goto	ErrorByte	
;---------------------------------------------------------------
LongPreamble:           ;Long Preamble is minimum 20 ones
        movlw   LPreamb     
        goto    Prea1
Preamble:
        movlw   SPreamb ;need a minimum of 10 ones as a preamble
Prea1:	movwf	LOOPA
Prea2:	goto $+1
	goto $+1	
	nop
	call 	DCCOne
	decfsz	LOOPA,f
	goto	Prea2
	goto	pr1
pr1:	goto	pr11
pr11:	goto	pr3
pr3:	nop
	goto 	DCCZero	;Indicate Start bit before address byte
	

;--------------------------------------------------------
ByteTx:	movlw	.8
	movwf	txCount
	bcf	STATUS,0
Byte1:	btfss	txByte,7
	goto	Byte2
	;nop
	;nop
	call	DCCOne
	goto $+1	
Byte3:	rlf	txByte,F
	decfsz	txCount,F
	goto	Byte1	
	return
Byte2:	call	DCCZero
	goto	Byte3	
;-------------------------------------------------------


ErrorByte
        call    DCCZero         ;preface error byte with DCCzero 
	movfw	byte1bf
	xorwf	byte2bf,w	;exclusive or bit wise byte1 and 2 buffers
	xorwf	byte3bf,w	;provide for extended packets (3-4) for later
	xorwf	byte4bf,w
	movwf	txByte
	call	ByteTx
	call	DCCOne		;end packet with ONE
        clrf    byte3bf
        clrf    byte4bf         ;reset those 2 - 1 and 2 always used
        movf    ModeFl,f
        btfsc   Status,Z 
        call    KeyTest        
        goto    DCCZero       
        return

;----------------------------------------------------------
DCCOne:

	goto $+1	
	movlw   .3	;for 58us pulse (4*10us+10+8)
	movwf   loops
	call    t10us
        call    toggle
	goto $+1
	nop	
	movlw   .4	;for 58us
	movwf   loops
	call    t10us
        goto    toggle
	
;----------------------------------
DCCZero:
       
        goto $+1        
        nop
	movlw   .7	;for 100us pulse (9*10us+10)
	movwf   loops
	call    t10us
        call    toggle
	movlw   .8	;for 10us pulse (1*10us)
        goto $+1
        goto $+1	
	movwf   loops
	call    t10us
        goto    toggle
	
;------------------------------------
toggle
        movlw   b'00000001' ;mask for XOR
        xorwf   porta,f
        return

;------------------------------------

bin2bcd

; 16 bit binary to 5 digit BCD
; e.g. MSB LSB  R0 R1 R2
;       ff  ff  06 55 35

	bcf    Status,C
        movlw  .16
        movwf  count
        clrf   R0
        clrf   R1
        clrf   R2
loop16: rlf    LSB,F
	rlf    MSB,F
        rlf    R2,F
        rlf    R1,F
        rlf    R0,F
        decfsz count,F
        goto   adjdec
        retlw  0
adjdec: movlw  R2        
        call   adjbcd
        movlw  R1        
        call   Adjbcd
        movlw  R0        
        call   adjbcd
        goto   loop16
adjbcd: movwf  FSR
        movlw  .3
        addwf  indf,W
        movwf  temp
        btfsc  temp,3
        movwf  indf
        movlw  30h
        addwf  indf,W
        movwf  temp
        btfsc  temp,7
        movwf  .0
        retlw  .0
        



;-------------------------------- 
; measures from 2 ms to 500ms seconds - Enter with loops set at desired value
t2ms    movfw  loops        
        movwf  NewLoops ;save original value
t2ms1  ; clrwdt
        movlw  .200
        movfw  loops
        call   t10us 
        decfsz NewLoops,F
        goto   t2ms1
        retlw  0 

;---------------------------------------------------------



t10us      ;measures from 10 us to 2.5ms - Enter with loops set at desired
           ;delay
	nop  ; additional delay of 5 us with 5 nop here
        goto $+1
        goto $+1
t10us2
        movlw   .1
        movwf   loops2         
t10us1  nop
        goto $+1   
	decfsz  loops2,F         
	goto    t10us1
        decfsz  loops,F
        goto    t10us2
        retlw   0
;------------------------------------------------------------------------
        IF DISPLAY == 162
Wait2Sec
        movlw   .10
        movwf   R0
Wait2   movlw   .50
        movwf   loops
        call    T2ms
        decfsz  R0,f
        goto    Wait2
        return
        ENDIF
;======================================================================= 
        END 

       
